package net.cscott.pcbmill;

import java.awt.*;
import java.awt.geom.*;
import java.io.*;
import java.util.*;

import org.apache.batik.svggen.*;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.transcoder.Transcoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.svg2svg.SVGTranscoder;
import org.apache.batik.util.*;
import org.w3c.dom.*;
import org.w3c.dom.svg.*;

/** This class creates SVG output for an input Shape. */
public abstract class SVGOutput {

    public void convertShapeAndStream(OutputStream outstream, int dpi)
	throws java.io.IOException {
	Writer outwriter = new OutputStreamWriter(outstream, "UTF-8");
	Document doc = paintShape(dpi);
	TranscoderInput tin = new TranscoderInput(doc);
	TranscoderOutput tout = new TranscoderOutput(outwriter);
	Transcoder transcoder = new SVGTranscoder();
	transcoder.addTranscodingHint
	    (SVGTranscoder.KEY_XML_DECLARATION,
	     "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
	transcoder.addTranscodingHint
	    (SVGTranscoder.KEY_DOCTYPE, SVGTranscoder.VALUE_DOCTYPE_CHANGE);
	transcoder.addTranscodingHint
	    (SVGTranscoder.KEY_PUBLIC_ID, SVGConstants.SVG_PUBLIC_ID);
	transcoder.addTranscodingHint
	    (SVGTranscoder.KEY_SYSTEM_ID, SVGConstants.SVG_SYSTEM_ID);

	try {
	    transcoder.transcode(tin, tout);
	    outwriter.flush(); outstream.flush();
	} catch (TranscoderException e) {
	    throw new java.io.IOException(e.toString());
	}
    }
    public SVGDocument paintShape(int dpi) {
	// Get a DOMImplementation
        DOMImplementation domImpl =
            SVGDOMImplementation.getDOMImplementation();
        // Create an instance of org.w3c.dom.Document
        SVGDocument document = (SVGDocument)
	    domImpl.createDocument(SVGDOMImplementation.SVG_NAMESPACE_URI,
				   "svg", null);

        // Create an instance of the SVG Generator
	SVGGeneratorContext ctx = SVGGeneratorContext.createDefault(document);
	ctx.setComment("Generated by Mallard"+
		       " with Batik SVG Generator");
	ctx.setEmbeddedFontsOn(true);
	SVGGraphics2D svgGenerator = new SVGGraphics2D(ctx, false);

        // Render the image into the SVG Graphics2D implementation
	svgGenerator.setPaint(Color.black);
	Rectangle2D bounds = doPaint(svgGenerator);

	double minX = bounds.getMinX();
	double minY = bounds.getMinY();
	double maxX = bounds.getMaxX();
	double maxY = bounds.getMaxY();

	// add a stroke width to be safe. (stroke width is 1/dpi)
	minX -= 1./dpi;
	minY -= 1./dpi;
	maxX += 1./dpi;
	maxY += 1./dpi;

	// populate the document root with the generated SVG content.
	Element root = document.getDocumentElement();
	root = svgGenerator.getRoot(root);
	//root = svgGenerator.getRoot(/*root*/); // for new batik.jar?

	// make sure the x, y, width, height, and viewBox attributes are
	// set correctly.
	root.setAttributeNS(null, "x", minX+"in");
	root.setAttributeNS(null, "y", minY+"in");
	root.setAttributeNS(null, "width", (maxX-minX)+"in");
	root.setAttributeNS(null, "height", (maxY-minY)+"in");
	root.setAttributeNS(null, "viewBox",
			    (minX*dpi)+" "+
			    (minY*dpi)+" "+
			    ((maxX-minX)*dpi)+" "+
			    ((maxY-minY)*dpi));
	// enforce that the default and xlink namespace declarations appear
	// on the root element
	root.setAttributeNS(XMLConstants.XMLNS_NAMESPACE_URI,
			    XMLConstants.XMLNS_PREFIX,
			    SVGDOMImplementation.SVG_NAMESPACE_URI);
	root.setAttributeNS(XMLConstants.XMLNS_NAMESPACE_URI,
			    XMLConstants.XMLNS_PREFIX + ":" +
			    XMLConstants.XLINK_PREFIX,
			    XMLConstants.XLINK_NAMESPACE_URI);
	
	// done!
	return document;
    }
    /** Implement this method to draw the SVG diagram. */
    protected abstract Rectangle2D doPaint(Graphics2D g2);
}
