/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.apache.batik.gvt.AbstractGraphicsNode;
import org.apache.batik.gvt.CompositeShapePainter;
import org.apache.batik.gvt.FillShapePainter;
import org.apache.batik.gvt.ShapePainter;
import org.apache.batik.gvt.StrokeShapePainter;

public class ShapeNode
extends AbstractGraphicsNode {
    protected Shape shape;
    protected ShapePainter shapePainter;
    private Rectangle2D primitiveBounds;
    private Rectangle2D geometryBounds;
    private Shape paintedArea;
    private Shape sensitiveArea;

    public void setShape(Shape shape) {
        this.fireGraphicsNodeChangeStarted();
        this.invalidateGeometryCache();
        this.shape = shape;
        if (this.shapePainter != null) {
            if (shape != null) {
                this.shapePainter.setShape(shape);
            } else {
                this.shapePainter = null;
            }
        }
        this.fireGraphicsNodeChangeCompleted();
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShapePainter(ShapePainter shapePainter) {
        this.fireGraphicsNodeChangeStarted();
        this.invalidateGeometryCache();
        this.shapePainter = shapePainter;
        if (this.shapePainter != null && this.shape != this.shapePainter.getShape()) {
            this.shapePainter.setShape(this.shape);
        }
        this.fireGraphicsNodeChangeCompleted();
    }

    public ShapePainter getShapePainter() {
        return this.shapePainter;
    }

    public void paint(Graphics2D graphics2D) {
        if (this.isVisible) {
            super.paint(graphics2D);
        }
    }

    public void primitivePaint(Graphics2D graphics2D) {
        if (this.shapePainter != null) {
            this.shapePainter.paint(graphics2D);
        }
    }

    protected void invalidateGeometryCache() {
        super.invalidateGeometryCache();
        this.primitiveBounds = null;
        this.geometryBounds = null;
        this.paintedArea = null;
        this.sensitiveArea = null;
    }

    public boolean contains(Point2D point2D) {
        Rectangle2D rectangle2D = this.getBounds();
        if (rectangle2D == null || !rectangle2D.contains(point2D)) {
            return false;
        }
        switch (this.pointerEventType) {
            case 0: 
            case 1: 
            case 2: {
                Shape shape = this.getSensitiveArea();
                if (shape != null) {
                    return this.isVisible && shape.contains(point2D);
                }
                return false;
            }
            case 3: {
                return this.isVisible;
            }
            case 4: 
            case 5: 
            case 6: {
                Shape shape = this.getSensitiveArea();
                if (shape != null) {
                    return shape.contains(point2D);
                }
                return false;
            }
            case 7: {
                return true;
            }
            case 8: {
                return false;
            }
        }
        return false;
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = this.getBounds();
        if (rectangle2D2 != null) {
            return rectangle2D2.intersects(rectangle2D) && this.paintedArea != null && this.paintedArea.intersects(rectangle2D);
        }
        return false;
    }

    public Rectangle2D getPrimitiveBounds() {
        if (this.primitiveBounds == null) {
            if (this.shape == null || this.shapePainter == null) {
                return null;
            }
            this.primitiveBounds = this.shapePainter.getPaintedBounds2D();
            if (Thread.currentThread().isInterrupted()) {
                this.invalidateGeometryCache();
            }
        }
        return this.primitiveBounds;
    }

    public Shape getSensitiveArea() {
        if (this.sensitiveArea == null) {
            ShapePainter shapePainter = null;
            ShapePainter shapePainter2 = null;
            if (this.shapePainter instanceof StrokeShapePainter) {
                shapePainter = this.shapePainter;
            } else if (this.shapePainter instanceof FillShapePainter) {
                shapePainter2 = this.shapePainter;
            } else {
                CompositeShapePainter compositeShapePainter = (CompositeShapePainter)this.shapePainter;
                int n = 0;
                while (n < compositeShapePainter.getShapePainterCount()) {
                    ShapePainter shapePainter3 = compositeShapePainter.getShapePainter(n);
                    if (shapePainter3 instanceof StrokeShapePainter) {
                        shapePainter = shapePainter3;
                    } else if (shapePainter3 instanceof FillShapePainter) {
                        shapePainter2 = shapePainter3;
                    }
                    ++n;
                }
            }
            switch (this.pointerEventType) {
                case 0: 
                case 4: {
                    this.sensitiveArea = this.shapePainter.getPaintedArea();
                    break;
                }
                case 1: 
                case 5: {
                    if (shapePainter2 == null) break;
                    this.sensitiveArea = shapePainter2.getPaintedArea();
                    break;
                }
                case 2: 
                case 6: {
                    if (shapePainter == null) break;
                    this.sensitiveArea = shapePainter.getPaintedArea();
                    break;
                }
            }
        }
        return this.sensitiveArea;
    }

    public Rectangle2D getGeometryBounds() {
        if (this.geometryBounds == null) {
            if (this.shape == null) {
                return null;
            }
            this.geometryBounds = this.normalizeRectangle(this.shape.getBounds2D());
        }
        return this.geometryBounds;
    }

    public Shape getOutline() {
        return this.shape;
    }
}

