/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value.svg;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.value.AbstractValueManager;
import org.apache.batik.css.engine.value.FloatValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public abstract class GlyphOrientationManager
extends AbstractValueManager {
    public boolean isInheritedProperty() {
        return true;
    }

    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case 12: {
                return ValueConstants.INHERIT_VALUE;
            }
            case 28: {
                return new FloatValue(11, lexicalUnit.getFloatValue());
            }
            case 29: {
                return new FloatValue(13, lexicalUnit.getFloatValue());
            }
            case 30: {
                return new FloatValue(12, lexicalUnit.getFloatValue());
            }
            case 13: {
                float f = lexicalUnit.getIntegerValue();
                if (f != 0.0f) break;
                return new FloatValue(11, 0.0f);
            }
            case 14: {
                float f = lexicalUnit.getFloatValue();
                if (f != 0.0f) break;
                return new FloatValue(11, 0.0f);
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
    }

    public Value createFloatValue(short s, float f) throws DOMException {
        switch (s) {
            case 11: 
            case 12: 
            case 13: {
                return new FloatValue(s, f);
            }
        }
        throw this.createInvalidFloatValueDOMException(f);
    }
}

