/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.jar.Manifest;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentJarClassLoader;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.svg.XMLBaseSupport;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.script.Interpreter;
import org.apache.batik.script.InterpreterException;
import org.apache.batik.script.ScriptHandler;
import org.apache.batik.script.Window;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class BaseScriptingEnvironment {
    protected static final String EVENT_NAME = "event";
    protected static final String ALTERNATE_EVENT_NAME = "evt";
    protected BridgeContext bridgeContext;
    protected UserAgent userAgent;
    protected Document document;
    protected ParsedURL docPURL;

    public static boolean isDynamicDocument(Document document) {
        Element element = document.getDocumentElement();
        if (element.getNamespaceURI().equals("http://www.w3.org/2000/svg")) {
            if (element.getAttributeNS(null, "onabort").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onerror").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onresize").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onunload").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onscroll").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onzoom").length() > 0) {
                return true;
            }
            return BaseScriptingEnvironment.isDynamicElement(document.getDocumentElement());
        }
        return false;
    }

    public static boolean isDynamicElement(Element element) {
        if ("http://www.w3.org/2000/svg".equals(element.getNamespaceURI())) {
            String string = element.getLocalName();
            if (string.equals("script")) {
                return true;
            }
            if (string.startsWith("animate") || string.equals("set")) {
                return true;
            }
            if (element.getAttributeNS(null, "onkeyup").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onkeydown").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onkeypress").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onload").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onerror").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onactivate").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onclick").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onfocusin").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onfocusout").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onmousedown").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onmousemove").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onmouseout").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onmouseover").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onmouseup").length() > 0) {
                return true;
            }
            Node node = element.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1 && BaseScriptingEnvironment.isDynamicElement((Element)node)) {
                    return true;
                }
                node = node.getNextSibling();
            }
        }
        return false;
    }

    public BaseScriptingEnvironment(BridgeContext bridgeContext) {
        this.bridgeContext = bridgeContext;
        this.document = bridgeContext.getDocument();
        this.docPURL = new ParsedURL(((SVGDocument)this.document).getURL());
        this.userAgent = this.bridgeContext.getUserAgent();
    }

    public org.apache.batik.script.Window createWindow(Interpreter interpreter, String string) {
        return new Window(interpreter, string);
    }

    public org.apache.batik.script.Window createWindow() {
        return this.createWindow(null, null);
    }

    public void initializeEnvironment(Interpreter interpreter, String string) {
        interpreter.bindObject("window", this.createWindow(interpreter, string));
    }

    public void loadScripts() {
        org.apache.batik.script.Window window = null;
        NodeList nodeList = this.document.getElementsByTagNameNS("http://www.w3.org/2000/svg", "script");
        int n = nodeList.getLength();
        if (n == 0) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        int n2 = 0;
        while (n2 < n) {
            block23: {
                Serializable serializable;
                Closeable closeable;
                Object object;
                Object object2;
                Object object3;
                Element element = (Element)nodeList.item(n2);
                String string = element.getAttributeNS(null, "type");
                if (string.length() == 0) {
                    string = "text/ecmascript";
                }
                if (string.equals("application/java-archive")) {
                    try {
                        Manifest manifest;
                        String string2;
                        object3 = XLinkSupport.getXLinkHref(element);
                        object2 = new ParsedURL(XMLBaseSupport.getCascadedXMLBase(element), (String)object3);
                        this.checkCompatibleScriptURL(string, (ParsedURL)object2);
                        object = null;
                        try {
                            object = new URL(this.docPURL.toString());
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                        closeable = new DocumentJarClassLoader(new URL(((ParsedURL)object2).toString()), (URL)object);
                        serializable = ((URLClassLoader)closeable).findResource("META-INF/MANIFEST.MF");
                        if (serializable != null && (string2 = (manifest = new Manifest(((URL)serializable).openStream())).getMainAttributes().getValue("Script-Handler")) != null) {
                            ScriptHandler scriptHandler = (ScriptHandler)((ClassLoader)((Object)closeable)).loadClass(string2).newInstance();
                            if (window == null) {
                                window = this.createWindow();
                            }
                            scriptHandler.run(this.document, window);
                        }
                        break block23;
                    }
                    catch (Exception exception) {
                        if (this.userAgent != null) {
                            this.userAgent.displayError(exception);
                        }
                        break block23;
                    }
                }
                object3 = this.bridgeContext.getInterpreter(string);
                if (object3 == null) {
                    object2 = this.bridgeContext.getUserAgent();
                    if (object2 != null) {
                        object2.displayError(new Exception("Unknown language: " + string));
                    }
                    return;
                }
                if (!hashSet.contains(string)) {
                    hashSet.add(string);
                    this.initializeEnvironment((Interpreter)object3, string);
                }
                try {
                    object2 = XLinkSupport.getXLinkHref(element);
                    if (((String)object2).length() > 0) {
                        object = new ParsedURL(XMLBaseSupport.getCascadedXMLBase(element), (String)object2);
                        this.checkCompatibleScriptURL(string, (ParsedURL)object);
                        closeable = new InputStreamReader(((ParsedURL)object).openStream());
                    } else {
                        object = element.getFirstChild();
                        if (object == null) break block23;
                        serializable = new StringBuffer();
                        while (object != null) {
                            ((StringBuffer)serializable).append(object.getNodeValue());
                            object = object.getNextSibling();
                        }
                        closeable = new StringReader(((StringBuffer)serializable).toString());
                    }
                    object3.evaluate((Reader)closeable);
                }
                catch (IOException iOException) {
                    if (this.userAgent != null) {
                        this.userAgent.displayError(iOException);
                    }
                    return;
                }
                catch (InterpreterException interpreterException) {
                    this.handleInterpreterException(interpreterException);
                    return;
                }
                catch (SecurityException securityException) {
                    if (this.userAgent == null) break block23;
                    this.userAgent.displayError(securityException);
                }
            }
            ++n2;
        }
    }

    protected void checkCompatibleScriptURL(String string, ParsedURL parsedURL) {
        this.userAgent.checkLoadScript(string, parsedURL, this.docPURL);
    }

    public void dispatchSVGLoadEvent() {
        SVGSVGElement sVGSVGElement = (SVGSVGElement)this.document.getDocumentElement();
        String string = sVGSVGElement.getContentScriptType();
        Interpreter interpreter = this.bridgeContext.getInterpreter(string);
        if (interpreter == null) {
            UserAgent userAgent = this.bridgeContext.getUserAgent();
            if (userAgent != null) {
                userAgent.displayError(new Exception("Unknown language: " + string));
            }
            return;
        }
        this.dispatchSVGLoad(sVGSVGElement, interpreter, true, string);
    }

    protected void dispatchSVGLoad(Element element, final Interpreter interpreter, boolean bl, String string) {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                this.dispatchSVGLoad((Element)node, interpreter, bl, string);
            }
            node = node.getNextSibling();
        }
        DocumentEvent documentEvent = (DocumentEvent)((Object)element.getOwnerDocument());
        Event event = documentEvent.createEvent("SVGEvents");
        event.initEvent("SVGLoad", false, false);
        EventTarget eventTarget = (EventTarget)((Object)element);
        final String string2 = element.getAttributeNS(null, "onload");
        EventListener eventListener = null;
        if (string2.length() > 0) {
            if (bl) {
                this.checkCompatibleScriptURL(string, this.docPURL);
                bl = false;
            }
            eventListener = new EventListener(){

                public void handleEvent(Event event) {
                    try {
                        interpreter.bindObject(BaseScriptingEnvironment.EVENT_NAME, event);
                        interpreter.bindObject(BaseScriptingEnvironment.ALTERNATE_EVENT_NAME, event);
                        interpreter.evaluate(new StringReader(string2));
                    }
                    catch (IOException iOException) {
                    }
                    catch (InterpreterException interpreterException) {
                        BaseScriptingEnvironment.this.handleInterpreterException(interpreterException);
                    }
                }
            };
            eventTarget.addEventListener("SVGLoad", eventListener, false);
        }
        eventTarget.dispatchEvent(event);
        if (string2.length() > 0) {
            eventTarget.removeEventListener("SVGLoad", eventListener, false);
        }
    }

    protected void handleInterpreterException(InterpreterException interpreterException) {
        if (this.userAgent != null) {
            Exception exception = interpreterException.getException();
            this.userAgent.displayError(exception == null ? interpreterException : exception);
        }
    }

    protected void handleSecurityException(SecurityException securityException) {
        if (this.userAgent != null) {
            this.userAgent.displayError(securityException);
        }
    }

    protected class Window
    implements org.apache.batik.script.Window {
        protected Interpreter interpreter;
        protected String language;

        public Window(Interpreter interpreter, String string) {
            this.interpreter = interpreter;
            this.language = string;
        }

        public Object setInterval(String string, long l) {
            return null;
        }

        public Object setInterval(Runnable runnable, long l) {
            return null;
        }

        public void clearInterval(Object object) {
        }

        public Object setTimeout(String string, long l) {
            return null;
        }

        public Object setTimeout(Runnable runnable, long l) {
            return null;
        }

        public void clearTimeout(Object object) {
        }

        public DocumentFragment parseXML(String string, Document document) {
            return null;
        }

        public void getURL(String string, Window.GetURLHandler getURLHandler) {
        }

        public void getURL(String string, Window.GetURLHandler getURLHandler, String string2) {
        }

        public void alert(String string) {
        }

        public boolean confirm(String string) {
            return false;
        }

        public String prompt(String string) {
            return null;
        }

        public String prompt(String string, String string2) {
            return null;
        }

        public BridgeContext getBridgeContext() {
            return BaseScriptingEnvironment.this.bridgeContext;
        }

        public Interpreter getInterpreter() {
            return this.interpreter;
        }
    }
}

