/*
 * Decompiled with CFR 0.152.
 */
package net.cscott.jutil;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkSet<E>
extends AbstractSet<E>
implements Serializable {
    private final HashMap<E, EntryList<E>> hm;
    private EntryList<E> listhead = EntryList.init();
    private EntryList<E> listfoot;
    private static final boolean debug = false;

    public WorkSet() {
        this.listfoot = this.listhead.next;
        this.hm = new HashMap();
    }

    public WorkSet(int initialCapacity) {
        this.listfoot = this.listhead.next;
        this.hm = new HashMap(initialCapacity);
    }

    public WorkSet(int initialCapacity, float loadFactor) {
        this.listfoot = this.listhead.next;
        this.hm = new HashMap(initialCapacity, loadFactor);
    }

    public WorkSet(Collection<? extends E> c) {
        this.listfoot = this.listhead.next;
        this.hm = new HashMap(Math.max(2 * c.size(), 11));
        this.addAll(c);
    }

    public boolean addFirst(E o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (this.hm.containsKey(o)) {
            return false;
        }
        EntryList<E> nel = new EntryList<E>(o);
        this.listhead.add(nel);
        this.hm.put(o, nel);
        return true;
    }

    public boolean addLast(E o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (this.hm.containsKey(o)) {
            return false;
        }
        EntryList<E> nel = new EntryList<E>(o);
        this.listfoot.prev.add(nel);
        this.hm.put(o, nel);
        return true;
    }

    public E getFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.listhead.next.o;
    }

    public E getLast() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.listfoot.prev.o;
    }

    public E removeFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object o = this.listhead.next.o;
        this.hm.remove(o);
        this.listhead.next.remove();
        return o;
    }

    public E removeLast() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object o = this.listfoot.prev.o;
        this.hm.remove(o);
        this.listfoot.prev.remove();
        return o;
    }

    public E peek() {
        return this.getLast();
    }

    public E pop() {
        return this.removeLast();
    }

    public void push(E item) {
        this.add(item);
    }

    @Override
    public boolean add(E o) {
        return this.addLast(o);
    }

    @Override
    public void clear() {
        this.hm.clear();
        this.listhead.next = this.listfoot;
        this.listfoot.prev = this.listhead;
    }

    @Override
    public boolean contains(Object o) {
        return this.hm.containsKey(o);
    }

    @Override
    public boolean isEmpty() {
        return this.listhead.next == this.listfoot;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            EntryList<E> elp;
            {
                this.elp = WorkSet.this.listhead;
            }

            @Override
            public boolean hasNext() {
                return this.elp.next.next != null;
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object o = this.elp.next.o;
                this.elp = this.elp.next;
                return o;
            }

            @Override
            public void remove() {
                if (this.elp == WorkSet.this.listhead) {
                    throw new IllegalStateException();
                }
                WorkSet.this.hm.remove(this.elp.o);
                this.elp = this.elp.prev;
                this.elp.next.remove();
            }
        };
    }

    @Override
    public boolean remove(Object o) {
        if (!this.hm.containsKey(o)) {
            return false;
        }
        EntryList<E> elp = this.hm.remove(o);
        elp.remove();
        return true;
    }

    @Override
    public int size() {
        return this.hm.size();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EntryList<E>
    implements Serializable {
        final E o;
        EntryList<E> prev = null;
        EntryList<E> next = null;

        EntryList(E o) {
            this.o = o;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("[");
            EntryList<E> elp = this;
            while (elp != null) {
                sb.append(elp.o);
                if (elp.next != null) {
                    sb.append(", ");
                }
                elp = elp.next;
            }
            sb.append(']');
            return sb.toString();
        }

        static <T1, T2> boolean equals(EntryList<T1> el, Collection<T2> c) {
            int size = 0;
            EntryList elp = el.next;
            while (elp.next != null) {
                if (!c.contains(elp.o)) {
                    return false;
                }
                elp = elp.next;
                ++size;
            }
            return size == c.size();
        }

        void remove() {
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.prev = null;
            this.next = null;
        }

        void add(EntryList<E> nel) {
            nel.next = this.next;
            nel.prev = this;
            nel.next.prev = nel;
            this.next = nel.next.prev;
        }

        static <T> EntryList<T> init() {
            EntryList<Object> header = new EntryList<Object>(null);
            EntryList<Object> footer = new EntryList<Object>(null);
            header.next = footer;
            footer.prev = header;
            return header;
        }
    }
}

