/*
 * Decompiled with CFR 0.152.
 */
package net.cscott.jutil;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.cscott.jutil.IteratorEnumerator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueVector<E>
extends AbstractList<E>
implements Set<E>,
Cloneable {
    List<E> vect;
    Map<E, Integer> uniq;
    final boolean asSet = true;

    public UniqueVector() {
        this.vect = new ArrayList();
        this.uniq = new HashMap<E, Integer>();
    }

    public UniqueVector(int initialCapacity) {
        this.vect = new ArrayList(initialCapacity);
        this.uniq = new HashMap<E, Integer>(initialCapacity);
    }

    public UniqueVector(Collection<? extends E> c) {
        this(c.size());
        for (E el : c) {
            this.add(el);
        }
    }

    public synchronized void addElement(E obj) {
        this.add(obj);
    }

    @Override
    public void add(int index, E element) {
        if (element == null) {
            throw new NullPointerException();
        }
        this.removeElement(element);
        this.vect.add(index, element);
        for (int i = index; i < this.vect.size(); ++i) {
            this.uniq.put(element, new Integer(i));
        }
    }

    @Override
    public boolean add(E obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        if (this.contains(obj)) {
            return false;
        }
        this.vect.add(obj);
        this.uniq.put(obj, new Integer(this.vect.size() - 1));
        return true;
    }

    public int capacity() {
        throw new UnsupportedOperationException();
    }

    public synchronized UniqueVector<E> clone() throws CloneNotSupportedException {
        return new UniqueVector<E>(this);
    }

    @Override
    public boolean contains(Object elem) {
        return this.uniq.containsKey(elem);
    }

    public synchronized void copyInto(Object[] anArray) {
        if (anArray.length < this.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.vect.toArray(anArray);
    }

    @Override
    public Object[] toArray() {
        return this.vect.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.vect.toArray(a);
    }

    public synchronized E elementAt(int index) {
        return this.get(index);
    }

    @Override
    public E get(int index) {
        return this.vect.get(index);
    }

    public synchronized Enumeration<E> elements() {
        return new IteratorEnumerator<E>(this.vect.iterator());
    }

    public synchronized void ensureCapacity(int minCapacity) {
        ((ArrayList)this.vect).ensureCapacity(minCapacity);
    }

    public synchronized E firstElement() {
        return this.vect.get(0);
    }

    @Override
    public synchronized int indexOf(Object elem) {
        if (!this.contains(elem)) {
            return -1;
        }
        return this.uniq.get(elem);
    }

    public synchronized int indexOf(Object elem, int index) {
        int i = this.indexOf(elem);
        if (i < index) {
            return -1;
        }
        return i;
    }

    public synchronized void insertElementAt(E obj, int index) {
        this.add(index, obj);
    }

    @Override
    public boolean isEmpty() {
        return this.vect.size() == 0;
    }

    public synchronized E lastElement() {
        return this.vect.get(this.vect.size() - 1);
    }

    @Override
    public int lastIndexOf(Object elem) {
        return this.indexOf(elem);
    }

    public synchronized int lastIndexOf(Object elem, int index) {
        int in = this.lastIndexOf(elem);
        if (in > index) {
            return -1;
        }
        return in;
    }

    public synchronized void removeAllElements() {
        this.clear();
    }

    @Override
    public void clear() {
        this.vect.clear();
        this.uniq.clear();
    }

    public final synchronized boolean removeElement(Object obj) {
        if (!this.contains(obj)) {
            return false;
        }
        this.removeElementAt(this.indexOf(obj));
        return true;
    }

    public synchronized void removeElementAt(int index) {
        try {
            this.remove(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    @Override
    public E remove(int index) {
        if (index < 0 || index >= this.vect.size()) {
            throw new IndexOutOfBoundsException();
        }
        E obj = this.vect.get(index);
        this.vect.remove(index);
        this.uniq.remove(obj);
        for (int i = index; i < this.vect.size(); ++i) {
            this.uniq.put(this.vect.get(i), new Integer(i));
        }
        return obj;
    }

    public synchronized void setElementAt(E obj, int index) {
        this.set(index, obj);
    }

    @Override
    public E set(int index, E obj) {
        E old = this.vect.get(index);
        if (old.equals(obj)) {
            return obj;
        }
        this.remove(obj);
        this.uniq.put(obj, this.uniq.remove(old));
        this.vect.set(index, obj);
        return old;
    }

    @Override
    public int size() {
        return this.vect.size();
    }

    @Override
    public synchronized String toString() {
        return this.vect.toString();
    }

    public synchronized void trimToSize() {
        ((ArrayList)this.vect).trimToSize();
    }

    @Override
    public int hashCode() {
        int hc = 0;
        for (Object elem : this) {
            hc += elem == null ? 0 : elem.hashCode();
        }
        return hc;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Set)) {
            return false;
        }
        Set s = (Set)o;
        if (this.hashCode() != ((Object)s).hashCode()) {
            return false;
        }
        return this.containsAll(s) && s.containsAll(this);
    }

    public /* synthetic */ Object clone() throws CloneNotSupportedException {
        return this.clone();
    }
}

