/*
 * Decompiled with CFR 0.152.
 */
package net.cscott.jutil;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import net.cscott.jutil.AggregateSetFactory;
import net.cscott.jutil.Factories;
import net.cscott.jutil.LinearSet;
import net.cscott.jutil.PersistentSetFactory;
import net.cscott.jutil.SetFactory;
import net.cscott.jutil.UniqueStack;
import net.cscott.jutil.UniqueVector;
import net.cscott.jutil.WorkSet;

class TestSet {
    private static final boolean DEBUG = false;
    public static final TestSet ONE_OF_THESE = new TestSet(null);
    public static String NULL = null;
    final TestSet th = this;
    final Factory f;
    boolean failed = false;
    String section = "NONE";
    String last_check = "NONE";

    public static void main(String[] args) {
        Object[] universe = new Object[]{null, "a", "b", "c", "d", "smartmove", "rules", "cars", ONE_OF_THESE};
        TestSet.doit(HashSet.class);
        NULL = " this is a null.  No, really! ";
        TestSet.doit(UniqueVector.class);
        TestSet.doit(UniqueStack.class);
        TestSet.doit(WorkSet.class);
        NULL = null;
        TestSet.doit(LinearSet.class);
        TestSet.doit(new AggregateSetFactory(), "AggregateSetFactory");
        TestSet.doit(Factories.synchronizedSetFactory(Factories.hashSetFactory), "synchronized HashSet");
        TestSet.doit(new PersistentSetFactory(new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 == null) {
                    return o2 == null ? 0 : -1;
                }
                if (o2 == null) {
                    return o1 == null ? 0 : 1;
                }
                if (o1 instanceof Comparable && o2 instanceof Comparable) {
                    return ((Comparable)o1).compareTo(o2);
                }
                return o1.hashCode() - o2.hashCode();
            }
        }), "PersistentSetFactory");
    }

    static void doit(Class c) {
        try {
            final Constructor c1 = c.getConstructor(new Class[0]);
            final Constructor c2 = c.getConstructor(Class.forName("java.util.Collection"));
            Factory f = new Factory(){

                @Override
                Set build() {
                    try {
                        return (Set)c1.newInstance(new Object[0]);
                    }
                    catch (InvocationTargetException ite) {
                        throw (RuntimeException)ite.getTargetException();
                    }
                    catch (Throwable t) {
                        throw new RuntimeException(t.toString());
                    }
                }

                @Override
                Set build(Collection m) {
                    try {
                        return (Set)c2.newInstance(m);
                    }
                    catch (InvocationTargetException ite) {
                        throw (RuntimeException)ite.getTargetException();
                    }
                    catch (Throwable t) {
                        throw new RuntimeException(t.toString());
                    }
                }
            };
            TestSet.doit(f, c.toString());
        }
        catch (RuntimeException re) {
            System.err.println("SKIPPING: " + re);
            throw re;
        }
        catch (Error e) {
            System.err.println("SKIPPING: " + e);
            throw e;
        }
        catch (Throwable t) {
            System.err.println("SKIPPING: " + t);
        }
    }

    static void doit(final SetFactory mf, String str) {
        TestSet.doit(new Factory(){

            @Override
            Set build() {
                return mf.makeSet();
            }

            @Override
            Set build(Collection m) {
                return mf.makeSet(m);
            }
        }, str);
    }

    static void doit(Factory f, String str) {
        System.err.println("TESTING " + str);
        TestSet mt = new TestSet(f);
        mt.test();
        if (mt.failed) {
            System.err.println("FAILURES testing " + str);
        }
    }

    TestSet(Factory f) {
        this.f = f;
    }

    void check(boolean cond) {
        if (!cond) {
            System.err.println("FAIL(" + this.section + "): " + this.last_check);
            this.failed = true;
        }
    }

    void debug(String s) {
    }

    void checkPoint(String name) {
        this.section = name;
    }

    void checkPoint2(String name) {
        this.last_check = name;
    }

    public void check(Object result, Object expected) {
        boolean ok = result == null ? expected == null : result.equals(expected);
        this.check(ok);
        if (!ok) {
            this.debug("got " + result + " but expected " + expected);
        }
    }

    public void check(double result, double expected) {
        boolean ok = result == expected ? result != 0.0 || 1.0 / result == 1.0 / expected : result != result && expected != expected;
        this.check(ok);
        if (!ok) {
            this.debug("got " + result + " but expected " + expected);
        }
    }

    public void check(long result, long expected) {
        boolean ok = result == expected;
        this.check(ok);
        if (!ok) {
            this.debug("got " + result + " but expected " + expected);
        }
    }

    public void check(int result, int expected) {
        boolean ok = result == expected;
        this.check(ok);
        if (!ok) {
            this.debug("got " + result + " but expected " + expected);
        }
    }

    public void check(boolean result, String name) {
        this.checkPoint2(name);
        this.check(result);
    }

    public void check(Object result, Object expected, String name) {
        this.checkPoint2(name);
        this.check(result, expected);
    }

    public void check(int result, int expected, String name) {
        this.checkPoint2(name);
        this.check(result, expected);
    }

    public void check(long result, long expected, String name) {
        this.checkPoint2(name);
        this.check(result, expected);
    }

    public void check(double result, double expected, String name) {
        this.checkPoint2(name);
        this.check(result, expected);
    }

    public void fail(String name) {
        this.checkPoint2(name);
        this.check(false);
    }

    public void test() {
        this.test_equals();
        this.test_hashCode();
        this.test_add();
        this.test_addAll();
        this.test_clear();
        this.test_remove();
        this.test_removeAll();
        this.test_retainAll();
        this.test_contains();
        this.test_containsAll();
        this.test_isEmpty();
        this.test_size();
        this.test_iterator();
        this.test_toArray();
        this.test_toString();
    }

    public void test_equals() {
        this.th.checkPoint("equals(java.lang.Object)boolean");
        Set xas1 = this.f.build();
        Set xas2 = this.f.build();
        this.th.check(((Object)xas1).equals(xas2), "checking equality -- 1");
        this.th.check(!((Object)xas1).equals(null), "checking equality -- 2");
        this.th.check(!((Object)xas1).equals(this), "checking equality -- 3");
        this.th.check(((Object)xas1).equals(xas1), "checking equality -- 4");
        xas1.add(NULL);
        xas1.add("a");
        xas2.add("b");
        xas2.add(NULL);
        xas2.add("a");
        xas1.add("b");
        this.th.check(((Object)xas1).equals(xas2), "checking equality -- 5");
        this.th.check(((Object)xas1).equals(xas1), "checking equality -- 6");
    }

    public void test_hashCode() {
        this.th.checkPoint("hashCode()int");
        Set xas = this.f.build();
        this.th.check(((Object)xas).hashCode() == 0, "checking hc-algorithm -- 1");
        if (NULL == null) {
            xas.add(NULL);
            this.th.check(((Object)xas).hashCode() == 0, "checking hc-algorithm -- 2");
        }
        xas.add("a");
        int hash = "a".hashCode();
        this.th.check(((Object)xas).hashCode() == hash, "checking hc-algorithm -- 3");
        xas.add("b");
        this.th.check(((Object)xas).hashCode() == (hash += "b".hashCode()), "checking hc-algorithm -- 4");
        xas.add("c");
        this.th.check(((Object)xas).hashCode() == (hash += "c".hashCode()), "checking hc-algorithm -- 5");
        xas.add("d");
        this.th.check(((Object)xas).hashCode() == (hash += "d".hashCode()), "checking hc-algorithm -- 6");
    }

    public void test_add() {
        this.th.checkPoint("add(java.lang.Object)boolean");
        Set ac = this.f.build();
        if (!ac.add(ONE_OF_THESE)) {
            this.th.fail("should return true.");
        }
    }

    public void test_addAll() {
        this.th.checkPoint("addAll(java.util.Collection)boolean");
        Vector<String> v = new Vector<String>();
        v.add("a");
        v.add("b");
        v.add("c");
        v.add("d");
        Set ac = this.f.build();
        this.th.check(ac.addAll(v), "should return true, v is modified");
        this.th.check(((Object)ac).equals(new HashSet(v)), "check everything is added");
        try {
            ac.addAll(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
    }

    public void test_clear() {
        this.th.checkPoint("clear()void");
        Set ac = this.f.build();
        ac.add("a");
        ac.add("b");
        ac.add("c");
        ac.add("d");
        ac.clear();
        this.th.check(ac.size() == 0, "all elements are removed -- 1");
        ac.clear();
        this.th.check(ac.size() == 0, "all elements are removed -- 2");
    }

    public void test_remove() {
        this.th.checkPoint("remove(java.lang.Object)boolean");
        Set ac = this.f.build();
        ac.add("a");
        ac.add(NULL);
        ac.add("c");
        ac.add("a");
        this.th.check(ac.size() == 3, "no duplicates at start -- 1");
        this.th.check(ac.remove("a"), "returns true if removed -- 2");
        this.th.check(ac.size() == 2, "one element was removed -- 2");
        this.th.check(!ac.remove("a"), "returns false if not removed -- 3");
        this.th.check(ac.size() == 2, "no elements were removed -- 3");
        this.th.check(ac.remove(NULL), "returns true if removed -- 4");
        this.th.check(ac.size() == 1, "one element was removed -- 4");
        this.th.check(!ac.remove(NULL), "returns false if not removed -- 5");
        this.th.check(ac.size() == 1, "no elements were removed -- 5");
        this.th.check(ac.contains("c"), "\"c\" is left");
        this.th.check(ac.remove("c"), "returns true if removed -- 6");
        this.th.check(ac.size() == 0, "no elements were removed -- 6");
    }

    public void test_removeAll() {
        this.th.checkPoint("removeAll(java.util.Collection)boolean");
        Set ac = this.f.build();
        ac.add("a");
        ac.add(NULL);
        ac.add("c");
        ac.add("a");
        try {
            ac.removeAll(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        Vector<String> v = new Vector<String>();
        v.add("a");
        v.add(NULL);
        v.add("de");
        v.add("fdf");
        this.th.check(ac.removeAll(v), "should return true");
        this.th.check(ac.size() == 1, "duplicate elements are removed");
        this.th.check(ac.contains("c"), "check if correct elements were removed");
        this.th.check(!ac.removeAll(v), "should return false");
        this.th.check(ac.size() == 1, "no elements were removed");
    }

    public void test_retainAll() {
        this.th.checkPoint("retainAll(java.util.Collection)boolean");
        Set ac = this.f.build();
        ac.add("a");
        ac.add(NULL);
        ac.add("c");
        ac.add("a");
        this.th.check(ac.size() == 3, "duplicate elements are not present");
        try {
            ac.retainAll(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        Vector<String> v = new Vector<String>();
        v.add("a");
        v.add(NULL);
        v.add("de");
        v.add("fdf");
        this.th.check(ac.retainAll(v), "should return true");
        this.th.check(ac.size() == 2, "proper elements are retained");
        this.th.check(!ac.retainAll(v), "should return false");
        this.th.check(ac.size() == 2, "all elements were retained");
        this.th.check(ac.contains(NULL) && ac.contains("a"));
    }

    public void test_contains() {
        this.th.checkPoint("contains(java.lang.Object)boolean");
        Set ac = this.f.build();
        ac.add("a");
        ac.add(NULL);
        ac.add("c");
        ac.add("a");
        this.th.check(ac.contains("a"), "true -- 1");
        this.th.check(ac.contains(NULL), "true -- 2");
        this.th.check(ac.contains("c"), "true -- 3");
        this.th.check(!ac.contains("ab"), "false -- 4");
        this.th.check(!ac.contains("b"), "false -- 5");
        ac.remove(NULL);
        this.th.check(!ac.contains(NULL), "false -- 4");
    }

    public void test_containsAll() {
        this.th.checkPoint("containsAll(java.util.Collection)boolean");
        Set ac = this.f.build();
        ac.add("a");
        ac.add(NULL);
        ac.add("c");
        ac.add("a");
        try {
            ac.containsAll(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        Vector<String> v = new Vector<String>();
        this.th.check(ac.containsAll(v), "should return true -- 1");
        v.add("a");
        v.add(NULL);
        v.add("a");
        v.add(NULL);
        v.add("a");
        this.th.check(ac.containsAll(v), "should return true -- 2");
        v.add("c");
        this.th.check(ac.containsAll(v), "should return true -- 3");
        v.add("c+");
        this.th.check(!ac.containsAll(v), "should return false -- 4");
        v.clear();
        ac.clear();
        this.th.check(ac.containsAll(v), "should return true -- 5");
    }

    public void test_isEmpty() {
        this.th.checkPoint("isEmpty()boolean");
        Set ac = this.f.build();
        this.th.check(ac.isEmpty(), "should return true -- 1");
        this.th.check(ac.isEmpty(), "should return true -- 2");
        ac.add(NULL);
        this.th.check(!ac.isEmpty(), "should return false -- 3");
        ac.clear();
        this.th.check(ac.isEmpty(), "should return true -- 4");
    }

    public void test_size() {
        this.th.checkPoint("()");
    }

    public void test_iterator() {
        this.th.checkPoint("()");
    }

    public void test_toArray() {
        int i;
        this.th.checkPoint("toArray()[java.lang.Object");
        Set ac = this.f.build();
        Object[] oa = ac.toArray();
        this.th.check(oa != null, "returning null is not allowed");
        if (oa != null) {
            this.th.check(oa.length == 0, "empty array");
        }
        ac.add("a");
        ac.add(NULL);
        ac.add("c");
        ac.add("a");
        this.th.check(ac.size() == 3, "duplicate adds are ignored");
        oa = ac.toArray();
        this.th.check(oa.length == 3, "output array is same size as set");
        this.th.check(Arrays.asList(oa).contains("a"), "checking elements: a");
        this.th.check(Arrays.asList(oa).contains("c"), "checking elements: c");
        this.th.check(Arrays.asList(oa).contains(NULL), "checking elements: null");
        this.th.checkPoint("toArray([java.lang.Object)[java.lang.Object");
        try {
            ac.toArray((T[])null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        String[] sa = new String[4];
        for (i = 0; i < sa.length; ++i) {
            sa[i] = "ok";
        }
        oa = ac.toArray(sa);
        this.th.check(oa.length >= 3, "output array is as least as large as set");
        this.th.check(Arrays.asList(oa).contains("a"), "checking elements: a");
        this.th.check(Arrays.asList(oa).contains("c"), "checking elements: c");
        this.th.check(Arrays.asList(oa).contains(NULL), "checking elements: null");
        this.th.check(!Arrays.asList(oa).contains("ok"), "checking elements: not 'ok'");
        this.th.check(oa == sa, "array large enough --> fill + return it");
        this.th.check(sa[3] == null, "element at 'size' is set to null");
        sa = new String[2];
        for (i = 0; i < sa.length; ++i) {
            sa[i] = "ok";
        }
        oa = ac.toArray(sa);
        this.th.check(oa.length >= 3, "output array is as least as large as set");
        this.th.check(Arrays.asList(oa).contains("a"), "checking elements: a");
        this.th.check(Arrays.asList(oa).contains("c"), "checking elements: c");
        this.th.check(Arrays.asList(oa).contains(NULL), "checking elements: null");
        this.th.check(oa instanceof String[], "checking  class type of returnvalue");
        sa = new String[3];
        Class<?> asc = sa.getClass();
        for (int i2 = 0; i2 < sa.length; ++i2) {
            sa[i2] = "ok";
        }
        oa = ac.toArray(sa);
        this.th.check(oa.length >= 3, "output array is as least as large as set");
        this.th.check(Arrays.asList(oa).contains("a"), "checking elements: a");
        this.th.check(Arrays.asList(oa).contains("c"), "checking elements: c");
        this.th.check(Arrays.asList(oa).contains(NULL), "checking elements: null");
        this.th.check(oa instanceof String[], "checking  class type of returnvalue");
        this.th.check(oa == sa, "array large enough --> fill + return it");
    }

    public void test_toString() {
        this.th.checkPoint("toString()java.lang.String");
        Set ac = this.f.build();
        ac.add("smartmove");
        ac.add(NULL);
        ac.add("rules");
        ac.add("cars");
        String s = ac.toString();
        this.th.check(s.indexOf("smartmove") != -1, "checking representations");
        this.th.check(s.indexOf("rules") != -1, "checking representations");
        this.th.check(s.indexOf("cars") != -1, "checking representations");
        this.th.check(s.indexOf("null") != -1, "checking representations");
        this.th.debug(s);
    }

    static abstract class Factory {
        Factory() {
        }

        abstract Set build();

        abstract Set build(Collection var1);
    }
}

