/*
 * Decompiled with CFR 0.152.
 */
package net.cscott.jutil;

import java.util.Comparator;
import net.cscott.jutil.BinaryTree;

public class RedBlackTree
extends BinaryTree {
    private static final boolean DEBUG = false;
    private static final int RED = 0;
    private static final int BLACK = 1;
    static final /* synthetic */ boolean $assertionsDisabled;

    private void checkRep() {
    }

    private void checkTree(BinaryTree.Node n) {
        if (n == this.NIL && !$assertionsDisabled && this.color(n) != 1) {
            throw new AssertionError((Object)"(2) viol.");
        }
        if (this.color(n) == 0) {
            if (!$assertionsDisabled && this.color(n.left()) != 1) {
                throw new AssertionError((Object)("(3) left viol. on " + n));
            }
            if (!$assertionsDisabled && this.color(n.right()) != 1) {
                throw new AssertionError((Object)("(3) right viol. on " + n));
            }
        }
        if (n != this.NIL) {
            this.checkTree(n.left());
            this.checkTree(n.right());
        }
    }

    protected BinaryTree.Node makeNode(Object o) {
        return new RBNode(o);
    }

    public RedBlackTree() {
    }

    public RedBlackTree(Comparator c) {
        super(c);
    }

    private int color(BinaryTree.Node n) {
        if (n == this.NIL) {
            return 1;
        }
        return ((RBNode)n).color;
    }

    private void setColor(BinaryTree.Node n, int c) {
        ((RBNode)n).color = c;
    }

    protected void insertNode(BinaryTree.Node x) {
        this.checkRep();
        super.insertNode(x);
        this.setColor(x, 0);
        while (x != this.root() && this.color(x.parent()) == 0) {
            BinaryTree.Node y;
            if (x.parent() == x.parent().parent().left()) {
                y = x.parent().parent().right();
                if (this.color(y) == 0) {
                    this.setColor(x.parent(), 1);
                    this.setColor(y, 1);
                    this.setColor(x.parent().parent(), 0);
                    x = x.parent().parent();
                    continue;
                }
                if (x == x.parent().right()) {
                    x = x.parent();
                    this.leftRotate(x);
                }
                this.setColor(x.parent(), 1);
                this.setColor(x.parent().parent(), 0);
                this.rightRotate(x.parent().parent());
                continue;
            }
            y = x.parent().parent().left();
            if (this.color(y) == 0) {
                this.setColor(x.parent(), 1);
                this.setColor(y, 1);
                this.setColor(x.parent().parent(), 0);
                x = x.parent().parent();
                continue;
            }
            if (x == x.parent().left()) {
                x = x.parent();
                this.rightRotate(x);
            }
            this.setColor(x.parent(), 1);
            this.setColor(x.parent().parent(), 0);
            this.leftRotate(x.parent().parent());
        }
        this.setColor(this.root(), 1);
        this.checkRep();
    }

    protected void swapPositions(BinaryTree.Node a, BinaryTree.Node b) {
        super.swapPositions(a, b);
        int c = this.color(a);
        this.setColor(a, this.color(b));
        this.setColor(b, c);
    }

    protected void deleteNode(BinaryTree.Node z) {
        this.checkRep();
        BinaryTree.Node y = z.left() == this.NIL || z.right() == this.NIL ? z : this.successor(z);
        BinaryTree.Node x = y.left() != this.NIL ? y.left() : y.right();
        this.setParent(x, y.parent());
        if (y.parent() == this.NIL) {
            this.setRoot(x);
        } else if (y == y.parent().left()) {
            this.setLeft(y.parent(), x);
        } else {
            this.setRight(y.parent(), x);
        }
        if (y != z) {
            this.swapPositions(y, z);
        }
        if (this.color(z) == 1) {
            this.rbDeleteFixup(x);
        }
        this.checkRep();
    }

    protected void rbDeleteFixup(BinaryTree.Node x) {
        while (x != this.root() && this.color(x) == 1) {
            BinaryTree.Node w;
            if (x == x.parent().left()) {
                w = x.parent().right();
                if (!$assertionsDisabled && w == this.NIL) {
                    throw new AssertionError();
                }
                if (this.color(w) == 0) {
                    this.setColor(w, 1);
                    this.setColor(x.parent(), 0);
                    this.leftRotate(x.parent());
                    w = x.parent().right();
                }
                if (this.color(w.left()) == 1 && this.color(w.right()) == 1) {
                    this.setColor(w, 0);
                    x = x.parent();
                    continue;
                }
                if (this.color(w.right()) == 1) {
                    this.setColor(w.left(), 1);
                    this.setColor(w, 0);
                    this.rightRotate(w);
                    w = x.parent().right();
                }
                this.setColor(w, this.color(x.parent()));
                this.setColor(x.parent(), 1);
                this.setColor(w.right(), 1);
                this.leftRotate(x.parent());
                x = this.root();
                continue;
            }
            w = x.parent().left();
            if (this.color(w) == 0) {
                this.setColor(w, 1);
                this.setColor(x.parent(), 0);
                this.rightRotate(x.parent());
                w = x.parent().left();
            }
            if (this.color(w.right()) == 1 && this.color(w.left()) == 1) {
                this.setColor(w, 0);
                x = x.parent();
                continue;
            }
            if (this.color(w.left()) == 1) {
                this.setColor(w.right(), 1);
                this.setColor(w, 0);
                this.leftRotate(w);
                w = x.parent().left();
            }
            this.setColor(w, this.color(x.parent()));
            this.setColor(x.parent(), 1);
            this.setColor(w.left(), 1);
            this.rightRotate(x.parent());
            x = this.root();
        }
        this.setColor(x, 1);
    }

    protected void leftRotate(BinaryTree.Node x) {
        BinaryTree.Node y = x.right();
        this.setRight(x, y.left());
        if (y.left() != this.NIL) {
            this.setParent(y.left(), x);
        }
        this.setParent(y, x.parent());
        if (x.parent() == this.NIL) {
            this.setRoot(y);
        } else if (x == x.parent().left()) {
            this.setLeft(x.parent(), y);
        } else {
            this.setRight(x.parent(), y);
        }
        this.setLeft(y, x);
        this.setParent(x, y);
    }

    protected void rightRotate(BinaryTree.Node x) {
        BinaryTree.Node y = x.left();
        this.setLeft(x, y.right());
        if (y.right() != this.NIL) {
            this.setParent(y.right(), x);
        }
        this.setParent(y, x.parent());
        if (x.parent() == this.NIL) {
            this.setRoot(y);
        } else if (x == x.parent().right()) {
            this.setRight(x.parent(), y);
        } else {
            this.setLeft(x.parent(), y);
        }
        this.setRight(y, x);
        this.setParent(x, y);
    }

    public static void main(String[] args) {
        new RedBlackTree().test();
    }

    static {
        $assertionsDisabled = !RedBlackTree.class.desiredAssertionStatus();
    }

    protected class RBNode
    extends BinaryTree.Node {
        private int color;

        protected RBNode(Object key) {
            super(key);
            this.color = 1;
        }

        public String toString() {
            return super.toString() + " col:" + (this.color == 1 ? "b" : "r");
        }
    }
}

