/*
 * Decompiled with CFR 0.152.
 */
package net.cscott.jutil;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Random;
import net.cscott.jutil.AbstractMapEntry;
import net.cscott.jutil.UnmodifiableIterator;
import net.cscott.jutil.Util;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class PersistentTreeNode<N extends PersistentTreeNode<N, K, V>, K, V>
extends AbstractMapEntry<K, V>
implements Serializable {
    public final K key;
    public final N left;
    public final N right;
    private static final int[] permute1;
    private static final int[] permute2;
    private static final int[] permute3;
    private static final int[] permute4;
    private static final short[] shuffle;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$net$cscott$jutil$PersistentTreeNode;

    PersistentTreeNode(K key, N left, N right) {
        this.key = key;
        this.left = left;
        this.right = right;
    }

    @Override
    public final K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return null;
    }

    @Override
    public String toString() {
        return new StringBuffer().append("[").append(this.key).append("->").append(this.getValue()).append(", left=").append(this.left).append(", right=").append(this.right).append("]").toString();
    }

    static <N extends PersistentTreeNode<N, K, V>, K, V> int depth(N n) {
        if (n == null) {
            return 0;
        }
        return 1 + Math.max(PersistentTreeNode.depth(n.left), PersistentTreeNode.depth(n.right));
    }

    static <N extends PersistentTreeNode<N, K, V>, K, V> int size(N n) {
        return n == null ? 0 : 1 + PersistentTreeNode.size(n.left) + PersistentTreeNode.size(n.right);
    }

    public boolean isSame(PersistentTreeNode n) {
        if (this == n) {
            return true;
        }
        if (null == n) {
            return false;
        }
        return PersistentTreeNode.isSame(this.key, n.key) && PersistentTreeNode.isSame(this.getValue(), n.getValue()) && PersistentTreeNode.isSame(this.left, n.left) && PersistentTreeNode.isSame(this.right, n.right);
    }

    private static boolean isSame(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private static boolean isSame(PersistentTreeNode n1, PersistentTreeNode n2) {
        return n1 == null ? n2 == null : n1.isSame(n2);
    }

    private static <N extends PersistentTreeNode<N, K, V>, K, V> N newNode(N n, K key, V value, N left, N right, Allocator<N, K, V> allocator) {
        if (n != null && PersistentTreeNode.isSame(n.key, key) && PersistentTreeNode.isSame(n.getValue(), value) && n.left == left && n.right == right) {
            return n;
        }
        if (!$assertionsDisabled && left != null && PersistentTreeNode.heapKey(key) >= PersistentTreeNode.heapKey(left.key)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && right != null && PersistentTreeNode.heapKey(key) > PersistentTreeNode.heapKey(right.key)) {
            throw new AssertionError();
        }
        return allocator.newNode(key, value, left, right);
    }

    private static <N extends PersistentTreeNode<N, K, V>, K, V> N newNode_balanceLeft(N n, K key, V value, N left, N right, Allocator<N, K, V> allocator) {
        if (left != null && left != n.left && PersistentTreeNode.heapKey(left.key) <= PersistentTreeNode.heapKey(key)) {
            return PersistentTreeNode.newNode(left, left.key, left.getValue(), left.left, PersistentTreeNode.newNode(n, key, value, left.right, right, allocator), allocator);
        }
        return PersistentTreeNode.newNode(n, key, value, left, right, allocator);
    }

    private static <N extends PersistentTreeNode<N, K, V>, K, V> N newNode_balanceRight(N n, K key, V value, N left, N right, Allocator<N, K, V> allocator) {
        if (right != null && right != n.right && PersistentTreeNode.heapKey(right.key) < PersistentTreeNode.heapKey(key)) {
            return PersistentTreeNode.newNode(right, right.key, right.getValue(), PersistentTreeNode.newNode(n, key, value, left, right.left, allocator), right.right, allocator);
        }
        return PersistentTreeNode.newNode(n, key, value, left, right, allocator);
    }

    static <N extends PersistentTreeNode<N, K, V>, K, V> N get(N n, Comparator<K> c, K key) {
        if (n == null) {
            return null;
        }
        int r = c.compare(key, n.key);
        return r == 0 ? n : (r < 0 ? PersistentTreeNode.get(n.left, c, key) : PersistentTreeNode.get(n.right, c, key));
    }

    static <N extends PersistentTreeNode<N, K, V>, K, V> N put(N n, Comparator<K> c, K key, V value, Allocator<N, K, V> allocator) {
        if (n == null) {
            return PersistentTreeNode.newNode(null, key, value, null, null, allocator);
        }
        int r = c.compare(key, n.key);
        if (r == 0) {
            return PersistentTreeNode.newNode(n, key, value, n.left, n.right, allocator);
        }
        if (r < 0) {
            return PersistentTreeNode.newNode_balanceLeft(n, n.key, n.getValue(), PersistentTreeNode.put(n.left, c, key, value, allocator), n.right, allocator);
        }
        if (r > 0) {
            return PersistentTreeNode.newNode_balanceRight(n, n.key, n.getValue(), n.left, PersistentTreeNode.put(n.right, c, key, value, allocator), allocator);
        }
        throw new Error("Impossible!");
    }

    static <N extends PersistentTreeNode<N, K, V>, K, V> N remove(N n, Comparator<K> c, K key, Allocator<N, K, V> allocator) {
        if (n == null) {
            return null;
        }
        int r = c.compare(key, n.key);
        if (r == 0) {
            return PersistentTreeNode.merge(n.left, n.right, c, allocator);
        }
        if (r < 0) {
            return PersistentTreeNode.newNode_balanceLeft(n, n.key, n.getValue(), PersistentTreeNode.remove(n.left, c, key, allocator), n.right, allocator);
        }
        if (r > 0) {
            return PersistentTreeNode.newNode_balanceRight(n, n.key, n.getValue(), n.left, PersistentTreeNode.remove(n.right, c, key, allocator), allocator);
        }
        throw new Error("Impossible!");
    }

    private static <N extends PersistentTreeNode<N, K, V>, K, V> NodePair<N, K, V> partition(K key, N node, Comparator<K> c, Allocator<N, K, V> allocator) {
        if (node == null) {
            return new NodePair(null, null);
        }
        int keycmp = c.compare(key, node.key);
        if (keycmp < 0) {
            NodePair<N, K, V> np = PersistentTreeNode.partition(key, node.left, c, allocator);
            return new NodePair(np.left, PersistentTreeNode.newNode(node, node.key, node.getValue(), np.right, node.right, allocator));
        }
        NodePair<N, K, V> np = PersistentTreeNode.partition(key, node.right, c, allocator);
        return new NodePair(PersistentTreeNode.newNode(node, node.key, node.getValue(), node.left, np.left, allocator), np.right);
    }

    private static <N extends PersistentTreeNode<N, K, V>, K, V> N merge(N left, N right, Comparator<K> c, Allocator<N, K, V> allocator) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        if (!$assertionsDisabled && c.compare(left.key, right.key) >= 0) {
            throw new AssertionError();
        }
        if (PersistentTreeNode.heapKey(left.key) > PersistentTreeNode.heapKey(right.key)) {
            return PersistentTreeNode.newNode(null, right.key, right.getValue(), PersistentTreeNode.merge(left, right.left, c, allocator), right.right, allocator);
        }
        return PersistentTreeNode.newNode(null, left.key, left.getValue(), left.left, PersistentTreeNode.merge(left.right, right, c, allocator), allocator);
    }

    static <N extends PersistentTreeNode<N, K, V>, K, V> N putAll(N origNode, N newNode, Comparator<K> c, Allocator<N, K, V> allocator) {
        int newHeapKey;
        if (origNode == null) {
            return newNode;
        }
        if (newNode == null) {
            return origNode;
        }
        int keycmp = c.compare(origNode.key, newNode.key);
        if (keycmp == 0) {
            return PersistentTreeNode.putAll(PersistentTreeNode.merge(origNode.left, origNode.right, c, allocator), newNode, c, allocator);
        }
        int origHeapKey = PersistentTreeNode.heapKey(origNode.key);
        if (origHeapKey < (newHeapKey = PersistentTreeNode.heapKey(newNode.key)) || origHeapKey == newHeapKey && keycmp < 0) {
            NodePair<N, K, V> np = PersistentTreeNode.partition(origNode.key, newNode, c, allocator);
            return PersistentTreeNode.newNode(origNode, origNode.key, origNode.getValue(), PersistentTreeNode.putAll(origNode.left, np.left, c, allocator), PersistentTreeNode.putAll(origNode.right, np.right, c, allocator), allocator);
        }
        NodePair<N, K, V> np = PersistentTreeNode.partition(newNode.key, origNode, c, allocator);
        return PersistentTreeNode.newNode(newNode, newNode.key, newNode.getValue(), PersistentTreeNode.putAll(np.left, newNode.left, c, allocator), PersistentTreeNode.putAll(np.right, newNode.right, c, allocator), allocator);
    }

    public static <N extends PersistentTreeNode<N, K, V>, K, V> Iterator<N> iterator(N root) {
        return new NodeIterator(root);
    }

    public static final <K> int heapKey(K treeKey) {
        int hash = treeKey == null ? 0 : treeKey.hashCode();
        hash = permute1[hash & 0xFF] | permute2[hash >> 8 & 0xFF] | permute3[hash >> 16 & 0xFF] | permute4[hash >>> 24];
        hash = shuffle[hash & 0xFF] | shuffle[hash >> 8 & 0xFF] << 8 | shuffle[hash >> 16 & 0xFF] << 16 | shuffle[hash >>> 24] << 24;
        return hash;
    }

    public static void main(String[] args) {
        int i;
        WithValue root = null;
        WithValue.Allocator allocator = new WithValue.Allocator();
        Comparator<Integer> c = new Comparator<Integer>(){

            @Override
            public int compare(Integer a, Integer b) {
                return a.compareTo(b);
            }

            @Override
            public /* synthetic */ int compare(Object x0, Object x1) {
                return this.compare((Integer)x0, (Integer)x1);
            }
        };
        int N = 1000;
        for (i = 1; i <= N; ++i) {
            root = PersistentTreeNode.put(root, c, new Integer(i), new Integer(i), allocator);
            System.out.println(new StringBuffer().append(i).append(" DEPTH ").append(PersistentTreeNode.depth(root)).append(" IDEAL ").append(Util.log2c(i)).toString());
        }
        for (i = N; i >= 1; --i) {
            root = PersistentTreeNode.remove(root, c, new Integer(i), allocator);
            System.out.println(new StringBuffer().append(i).append(" DEPTH ").append(PersistentTreeNode.depth(root)).append(" IDEAL ").append(Util.log2c(i)).toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        int tmp;
        int i;
        $assertionsDisabled = !(class$net$cscott$jutil$PersistentTreeNode == null ? (class$net$cscott$jutil$PersistentTreeNode = PersistentTreeNode.class$("net.cscott.jutil.PersistentTreeNode")) : class$net$cscott$jutil$PersistentTreeNode).desiredAssertionStatus();
        permute1 = new int[256];
        permute2 = new int[256];
        permute3 = new int[256];
        permute4 = new int[256];
        shuffle = new short[256];
        Random r = new Random(-2400476880961615174L);
        int[] bitpos = new int[32];
        for (i = 0; i < bitpos.length; ++i) {
            bitpos[i] = 1 << i;
        }
        for (i = 0; i < bitpos.length - 1; ++i) {
            int switcharoo = i + r.nextInt(bitpos.length - i);
            tmp = bitpos[i];
            bitpos[i] = bitpos[switcharoo];
            bitpos[switcharoo] = tmp;
        }
        for (int p = 0; p < 4; ++p) {
            int[] permute;
            switch (p) {
                case 0: {
                    permute = permute1;
                    break;
                }
                case 1: {
                    permute = permute2;
                    break;
                }
                case 2: {
                    permute = permute3;
                    break;
                }
                case 3: {
                    permute = permute4;
                    break;
                }
                default: {
                    throw new AssertionError((Object)"impossible!");
                }
            }
            for (int i2 = 0; i2 < permute.length; ++i2) {
                int result = 0;
                int input = i2 << p * 8;
                int j = 0;
                while (j < 32) {
                    if (0 != (input & 1)) {
                        result |= bitpos[j];
                    }
                    ++j;
                    input >>= 1;
                }
                permute[i2] = result;
            }
        }
        for (i = 0; i < shuffle.length; i = (int)((short)(i + 1))) {
            PersistentTreeNode.shuffle[i] = i;
        }
        for (i = 0; i < shuffle.length - 1; ++i) {
            int switcharoo = i + r.nextInt(shuffle.length - i);
            tmp = shuffle[i];
            PersistentTreeNode.shuffle[i] = shuffle[switcharoo];
            PersistentTreeNode.shuffle[switcharoo] = tmp;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WithValue<K, V>
    extends PersistentTreeNode<WithValue<K, V>, K, V> {
        final V value;
        final int mapHashCode;

        WithValue(K key, V value, WithValue<K, V> left, WithValue<K, V> right) {
            super(key, left, right);
            this.value = value;
            this.mapHashCode = this.hashCode() + (left == null ? 0 : left.mapHashCode) + (right == null ? 0 : right.mapHashCode);
        }

        @Override
        public V getValue() {
            return this.value;
        }

        int mapHashCode() {
            return this.mapHashCode;
        }

        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class Allocator<K, V>
        extends net.cscott.jutil.PersistentTreeNode$Allocator<WithValue<K, V>, K, V> {
            Allocator() {
            }

            @Override
            WithValue<K, V> newNode(K key, V value, WithValue<K, V> left, WithValue<K, V> right) {
                return new WithValue<K, V>(key, value, left, right);
            }

            @Override
            /* synthetic */ PersistentTreeNode newNode(Object x0, Object x1, PersistentTreeNode x2, PersistentTreeNode x3) {
                return this.newNode(x0, x1, (WithValue)x2, (WithValue)x3);
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeIterator<N extends PersistentTreeNode<N, K, V>, K, V>
    extends UnmodifiableIterator<N> {
        NodeList<N, K, V> stack = null;

        NodeIterator(N root) {
            N n = root;
            while (n != null) {
                this.stack = new NodeList<N, K, V>(n, this.stack);
                n = ((PersistentTreeNode)n).left;
            }
        }

        @Override
        public boolean hasNext() {
            return this.stack != null;
        }

        @Override
        public N next() {
            Object n = this.stack.head;
            this.stack = this.stack.tail;
            Object nn = ((PersistentTreeNode)n).right;
            while (nn != null) {
                this.stack = new NodeList(nn, this.stack);
                nn = ((PersistentTreeNode)nn).left;
            }
            return n;
        }

        @Override
        public /* synthetic */ Object next() {
            return this.next();
        }

        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class NodeList<N extends PersistentTreeNode<N, K, V>, K, V> {
            N head;
            NodeList<N, K, V> tail;

            NodeList(N head, NodeList<N, K, V> tail) {
                this.head = head;
                this.tail = tail;
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NodePair<N extends PersistentTreeNode<N, K, V>, K, V> {
        final N left;
        final N right;

        NodePair(N left, N right) {
            this.left = left;
            this.right = right;
        }

        public String toString() {
            return new StringBuffer().append("[").append(this.left).append(", ").append(this.right).append("]").toString();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class Allocator<N extends PersistentTreeNode<N, K, V>, K, V> {
        Allocator() {
        }

        abstract N newNode(K var1, V var2, N var3, N var4);
    }
}

