/*
 * Decompiled with CFR 0.152.
 */
package net.cscott.jutil;

import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import net.cscott.jutil.Default;
import net.cscott.jutil.PersistentTreeNode;
import net.cscott.jutil.SetFactory;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentSetFactory<T>
extends SetFactory<T> {
    final Allocator<T> allocator = new Allocator();
    final Comparator<T> comparator;
    static /* synthetic */ Class class$net$cscott$jutil$PersistentSetFactory;

    public PersistentSetFactory(Comparator<T> comparator) {
        this.comparator = comparator;
    }

    @Override
    public Set<T> makeSet(Collection<? extends T> c) {
        return new SetImpl(c);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Allocator<T>
    extends PersistentTreeNode.Allocator<Node<T>, T, T> {
        final WeakHashMap<Node<T>, WeakReference<Node<T>>> hashConsCache = new WeakHashMap();
        static final /* synthetic */ boolean $assertionsDisabled;

        Allocator() {
        }

        @Override
        Node<T> newNode(T key, T value, Node<T> left, Node<T> right) {
            if (!$assertionsDisabled && key != value) {
                throw new AssertionError();
            }
            Node<T> n = new Node<T>(key, left, right);
            WeakReference<Node<T>> nn = this.hashConsCache.get(n);
            if (nn == null) {
                nn = new WeakReference<Node<Node<T>>>(n);
                this.hashConsCache.put(n, nn);
            }
            return (Node)nn.get();
        }

        @Override
        /* synthetic */ PersistentTreeNode newNode(Object x0, Object x1, PersistentTreeNode x2, PersistentTreeNode x3) {
            return this.newNode(x0, x1, (Node)x2, (Node)x3);
        }

        static {
            $assertionsDisabled = !(class$net$cscott$jutil$PersistentSetFactory == null ? (class$net$cscott$jutil$PersistentSetFactory = PersistentSetFactory.class$("net.cscott.jutil.PersistentSetFactory")) : class$net$cscott$jutil$PersistentSetFactory).desiredAssertionStatus();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node<T>
    extends PersistentTreeNode<Node<T>, T, T> {
        final int setHashCode;
        final int size;

        Node(T key, Node<T> left, Node<T> right) {
            super(key, left, right);
            this.setHashCode = (key == null ? 0 : key.hashCode()) + (left == null ? 0 : left.setHashCode) + (right == null ? 0 : right.setHashCode);
            this.size = 1 + (left == null ? 0 : left.size) + (right == null ? 0 : right.size);
        }

        @Override
        public T getValue() {
            return (T)this.key;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Node)) {
                return false;
            }
            Node n = (Node)o;
            return (this.key == null ? n.key == null : this.key.equals(n.key)) && this.left == n.left && this.right == n.right;
        }

        @Override
        public int hashCode() {
            return this.setHashCode;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SetImpl
    extends AbstractSet<T> {
        Node<T> root = null;
        static final /* synthetic */ boolean $assertionsDisabled;

        SetImpl(Collection<? extends T> c) {
            this.addAll(c);
        }

        SetImpl(Node<T> root) {
            this.root = root;
        }

        @Override
        public boolean isEmpty() {
            return this.root == null;
        }

        @Override
        public int size() {
            return this.root == null ? 0 : this.root.size;
        }

        @Override
        public int hashCode() {
            return this.root == null ? 0 : this.root.setHashCode;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof SetImpl && this.factory() == ((SetImpl)o).factory()) {
                return this.root == ((SetImpl)o).root;
            }
            return super.equals(o);
        }

        private PersistentSetFactory<T> factory() {
            return PersistentSetFactory.this;
        }

        @Override
        public void clear() {
            this.root = null;
        }

        public PersistentSetFactory<T> clone() {
            return new SetImpl(this.root);
        }

        @Override
        public boolean contains(Object key) {
            return Node.get(this.root, PersistentSetFactory.this.comparator, key) != null;
        }

        @Override
        public boolean remove(Object key) {
            Node old_root = this.root;
            this.root = Node.remove(this.root, PersistentSetFactory.this.comparator, key, PersistentSetFactory.this.allocator);
            return old_root != this.root;
        }

        @Override
        public boolean add(T elem) {
            Node old_root = this.root;
            this.root = Node.put(this.root, PersistentSetFactory.this.comparator, elem, elem, PersistentSetFactory.this.allocator);
            return old_root != this.root;
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            if (c instanceof SetImpl && this.factory() == ((SetImpl)c).factory()) {
                Node old_root = this.root;
                this.root = Node.putAll(this.root, ((SetImpl)c).root, PersistentSetFactory.this.comparator, PersistentSetFactory.this.allocator);
                return old_root != this.root;
            }
            return super.addAll(c);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            if (c instanceof SetImpl && this.factory() == ((SetImpl)c).factory()) {
                return this.containsAll(this.root, ((SetImpl)c).root);
            }
            return super.containsAll(c);
        }

        @Override
        public Iterator<T> iterator() {
            Iterator it = Node.iterator(this.root);
            return new Iterator<T>(){
                Node<T> last;
                private final /* synthetic */ Iterator val$it;
                private final /* synthetic */ SetImpl this$1;
                {
                    this.this$1 = setImpl;
                    this.val$it = iterator;
                    this.last = null;
                }

                public boolean hasNext() {
                    return this.val$it.hasNext();
                }

                public T next() {
                    this.last = (Node)this.val$it.next();
                    return (T)this.last.key;
                }

                public void remove() {
                    if (this.last == null) {
                        throw new IllegalStateException();
                    }
                    this.this$1.remove(this.last.key);
                    this.last = null;
                }
            };
        }

        boolean containsAll(Node<T> container, Node<T> subset) {
            if (subset == null || container == subset) {
                return true;
            }
            if (container == null) {
                return false;
            }
            if (!($assertionsDisabled || container != null && subset != null)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && container == subset) {
                throw new AssertionError();
            }
            if (subset.size >= container.size) {
                return false;
            }
            Default.PairList pair = this.removeAndSplit(subset, container.key);
            return this.containsAll((Node)container.left, pair.left()) && this.containsAll((Node)container.right, pair.right());
        }

        Default.PairList<Node<T>, Node<T>> removeAndSplit(Node<T> node, T key) {
            if (node == null) {
                return new Default.PairList<Object, Object>(null, null);
            }
            int cmp = PersistentSetFactory.this.comparator.compare(node.key, key);
            if (cmp == 0) {
                return new Default.PairList<PersistentTreeNode, PersistentTreeNode>(node.left, node.right);
            }
            if (cmp < 0) {
                Default.PairList pair = this.removeAndSplit((Node)node.right, key);
                return new Default.PairList(PersistentSetFactory.this.allocator.newNode(node.key, node.getValue(), (Node)node.left, pair.left()), pair.right());
            }
            Default.PairList pair = this.removeAndSplit((Node)node.left, key);
            return new Default.PairList(pair.left(), PersistentSetFactory.this.allocator.newNode(node.key, node.getValue(), pair.right(), (Node)node.right));
        }

        public /* synthetic */ Object clone() throws CloneNotSupportedException {
            return this.clone();
        }

        static {
            $assertionsDisabled = !(class$net$cscott$jutil$PersistentSetFactory == null ? (class$net$cscott$jutil$PersistentSetFactory = PersistentSetFactory.class$("net.cscott.jutil.PersistentSetFactory")) : class$net$cscott$jutil$PersistentSetFactory).desiredAssertionStatus();
        }
    }
}

