/*
 * Decompiled with CFR 0.152.
 */
package net.cscott.jutil;

import java.util.AbstractSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import net.cscott.jutil.Default;
import net.cscott.jutil.PersistentTreeNode;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentSet<T> {
    final Node<T> root;
    final Comparator<T> c;
    final Node.Allocator<T> allocator;

    public PersistentSet() {
        this(Default.comparator);
    }

    public PersistentSet(Comparator<T> c) {
        this(null, c, new Node.Allocator());
    }

    private PersistentSet(Node<T> root, Comparator<T> c, Node.Allocator<T> a) {
        this.root = root;
        this.c = c;
        this.allocator = a;
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    public int size() {
        return this.root == null ? 0 : this.root.size;
    }

    public PersistentSet<T> add(T element) {
        Node<T> new_root = PersistentTreeNode.put(this.root, this.c, element, element, this.allocator);
        return this.root == new_root ? this : new PersistentSet<T>(new_root, this.c, this.allocator);
    }

    public boolean contains(T element) {
        return PersistentTreeNode.get(this.root, this.c, element) != null;
    }

    public PersistentSet<T> remove(T element) {
        Node<T> new_root = PersistentTreeNode.remove(this.root, this.c, element, this.allocator);
        return this.root == new_root ? this : new PersistentSet<T>(new_root, this.c, this.allocator);
    }

    public PersistentSet<T> addAll(PersistentSet<T> set) {
        if (((Object)this.c).equals(set.c) && this.allocator == set.allocator) {
            Node<T> new_root = Node.putAll(this.root, set.root, this.c, this.allocator);
            return new_root == this.root ? this : (new_root == set.root ? set : new PersistentSet<T>(new_root, this.c, this.allocator));
        }
        if (set.size() > this.size()) {
            return set.addAll(this);
        }
        Node<T> new_root = this.root;
        Iterator<Node<T>> it = Node.iterator(set.root);
        while (it.hasNext()) {
            Node<T> n = it.next();
            new_root = Node.put(new_root, this.c, n.key, n.getValue(), this.allocator);
        }
        return this.root == new_root ? this : new PersistentSet<T>(new_root, this.c, this.allocator);
    }

    public PersistentSet<T> clone() {
        return new PersistentSet<T>(this.root, this.c, this.allocator);
    }

    public String toString() {
        return this.asSet().toString();
    }

    public Set<T> asSet() {
        return new AbstractSet<T>(){

            public Set<T> clone() {
                return PersistentSet.this.asSet();
            }

            @Override
            public boolean contains(Object o) {
                return PersistentSet.this.contains(o);
            }

            @Override
            public boolean isEmpty() {
                return PersistentSet.this.isEmpty();
            }

            @Override
            public int size() {
                return PersistentSet.this.size();
            }

            @Override
            public Iterator<T> iterator() {
                Iterator it = Node.iterator(PersistentSet.this.root);
                return new Iterator<T>(){
                    Node<T> last;
                    private final /* synthetic */ Iterator val$it;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$it = iterator;
                        this.last = null;
                    }

                    public boolean hasNext() {
                        return this.val$it.hasNext();
                    }

                    public T next() {
                        this.last = (Node)this.val$it.next();
                        return (T)this.last.key;
                    }

                    public void remove() {
                        if (this.last == null) {
                            throw new IllegalStateException();
                        }
                        1.access$000(this.this$1).remove(this.last.getKey());
                        this.last = null;
                    }
                };
            }

            public /* synthetic */ Object clone() throws CloneNotSupportedException {
                return this.clone();
            }

            static /* synthetic */ PersistentSet access$000(1 x0) {
                return x0.PersistentSet.this;
            }
        };
    }

    public /* synthetic */ Object clone() throws CloneNotSupportedException {
        return this.clone();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node<T>
    extends PersistentTreeNode<Node<T>, T, T> {
        final int setHashCode;
        final int size;

        Node(T key, Node<T> left, Node<T> right) {
            super(key, left, right);
            this.setHashCode = (key == null ? 0 : key.hashCode()) + (left == null ? 0 : left.setHashCode) + (right == null ? 0 : right.setHashCode);
            this.size = 1 + (left == null ? 0 : left.size) + (right == null ? 0 : right.size);
        }

        @Override
        public T getValue() {
            return (T)this.key;
        }

        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class Allocator<T>
        extends PersistentTreeNode.Allocator<Node<T>, T, T> {
            Allocator() {
            }

            @Override
            Node<T> newNode(T key, T value, Node<T> left, Node<T> right) {
                return new Node<T>(key, left, right);
            }

            @Override
            /* synthetic */ PersistentTreeNode newNode(Object x0, Object x1, PersistentTreeNode x2, PersistentTreeNode x3) {
                return this.newNode(x0, x1, (Node)x2, (Node)x3);
            }
        }
    }
}

