/*
 * Decompiled with CFR 0.152.
 */
package net.cscott.jutil;

import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.cscott.jutil.AbstractMapEntry;
import net.cscott.jutil.MapFactory;
import net.cscott.jutil.MapSet;
import net.cscott.jutil.PersistentTreeNode;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentMapFactory<K, V>
extends MapFactory<K, V> {
    final Allocator<K, V> allocator = new Allocator();
    final Comparator<K> comparator;

    public PersistentMapFactory(Comparator<K> comparator) {
        this.comparator = comparator;
    }

    @Override
    public Map<K, V> makeMap(Map<? extends K, ? extends V> mm) {
        return new MapImpl(mm);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Allocator<K, V>
    extends PersistentTreeNode.Allocator<Node<K, V>, K, V> {
        final WeakHashMap<Node<K, V>, WeakReference<Node<K, V>>> hashConsCache = new WeakHashMap();

        Allocator() {
        }

        @Override
        Node<K, V> newNode(K key, V value, Node<K, V> left, Node<K, V> right) {
            Node<K, V> n = new Node<K, V>(key, value, left, right);
            WeakReference<Node<K, V>> nn = this.hashConsCache.get(n);
            if (nn == null) {
                nn = new WeakReference<Node<K, V>>(n);
                this.hashConsCache.put(n, nn);
            }
            return (Node)nn.get();
        }

        public String toString() {
            return this.hashConsCache.toString();
        }

        @Override
        /* synthetic */ PersistentTreeNode newNode(Object x0, Object x1, PersistentTreeNode x2, PersistentTreeNode x3) {
            return this.newNode(x0, x1, (Node)x2, (Node)x3);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node<K, V>
    extends PersistentTreeNode<Node<K, V>, K, V> {
        final V value;
        final int mapHashCode;
        final int size;

        Node(K key, V value, Node<K, V> left, Node<K, V> right) {
            super(key, left, right);
            this.value = value;
            this.mapHashCode = this.entryHashCode() + (left == null ? 0 : left.mapHashCode) + (right == null ? 0 : right.mapHashCode);
            this.size = 1 + (left == null ? 0 : left.size) + (right == null ? 0 : right.size);
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Node)) {
                return false;
            }
            Node n = (Node)o;
            return (this.key == null ? n.key == null : this.key.equals(n.key)) && (this.value == null ? n.value == null : this.value.equals(n.value)) && this.left == n.left && this.right == n.right;
        }

        @Override
        public int hashCode() {
            return this.mapHashCode;
        }

        public int entryHashCode() {
            return super.hashCode();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MapImpl
    extends AbstractMap<K, V> {
        Node<K, V> root = null;

        MapImpl(Map<? extends K, ? extends V> mm) {
            this.putAll(mm);
        }

        MapImpl(Node<K, V> root) {
            this.root = root;
        }

        @Override
        public boolean isEmpty() {
            return this.root == null;
        }

        @Override
        public int size() {
            return this.root == null ? 0 : this.root.size;
        }

        @Override
        public int hashCode() {
            return this.root == null ? 0 : this.root.mapHashCode;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof MapImpl && this.factory() == ((MapImpl)o).factory()) {
                return this.root == ((MapImpl)o).root;
            }
            return super.equals(o);
        }

        private PersistentMapFactory<K, V> factory() {
            return PersistentMapFactory.this;
        }

        @Override
        public void clear() {
            this.root = null;
        }

        @Override
        public PersistentMapFactory<K, V> clone() {
            return new MapImpl(this.root);
        }

        @Override
        public boolean containsKey(Object key) {
            return Node.get(this.root, PersistentMapFactory.this.comparator, key) != null;
        }

        @Override
        public V get(Object key) {
            Node np = Node.get(this.root, PersistentMapFactory.this.comparator, key);
            return np == null ? null : (Object)np.value;
        }

        void removeFast(Object key) {
            this.root = Node.remove(this.root, PersistentMapFactory.this.comparator, key, PersistentMapFactory.this.allocator);
        }

        @Override
        public V remove(Object key) {
            Object oldValue = this.get(key);
            this.removeFast(key);
            return oldValue;
        }

        void putFast(K key, V value) {
            this.root = Node.put(this.root, PersistentMapFactory.this.comparator, key, value, PersistentMapFactory.this.allocator);
        }

        @Override
        public V put(K key, V value) {
            Object oldValue = this.get(key);
            this.putFast(key, value);
            return oldValue;
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> mm) {
            if (mm instanceof MapImpl && this.factory() == ((MapImpl)mm).factory()) {
                this.root = Node.putAll(this.root, ((MapImpl)mm).root, PersistentMapFactory.this.comparator, PersistentMapFactory.this.allocator);
            } else {
                super.putAll(mm);
            }
        }

        public MapSet<K, V> entrySet() {
            return new EntrySet();
        }

        @Override
        public /* synthetic */ Object clone() throws CloneNotSupportedException {
            return this.clone();
        }

        @Override
        public /* synthetic */ Set entrySet() {
            return this.entrySet();
        }

        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class NodeWrapper
        extends AbstractMapEntry<K, V> {
            Node<K, V> node;

            NodeWrapper(Node<K, V> node) {
                this.node = node;
            }

            @Override
            public K getKey() {
                return this.node.key;
            }

            @Override
            public V getValue() {
                return this.node.value;
            }

            @Override
            public V setValue(V value) {
                Object oldValue = this.node.value;
                MapImpl.this.putFast(this.node.key, value);
                this.node = Node.get(MapImpl.this.root, ((MapImpl)MapImpl.this).PersistentMapFactory.this.comparator, this.node.key);
                return oldValue;
            }
        }

        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class EntrySet
        extends AbstractSet<Map.Entry<K, V>>
        implements MapSet<K, V> {
            private EntrySet() {
            }

            @Override
            public int size() {
                return MapImpl.this.size();
            }

            @Override
            public PersistentMapFactory<K, V> asMap() {
                return MapImpl.this;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                Iterator it = Node.iterator(MapImpl.this.root);
                return new Iterator<Map.Entry<K, V>>(){
                    Node<K, V> last;
                    private final /* synthetic */ Iterator val$it;
                    private final /* synthetic */ EntrySet this$2;
                    {
                        this.this$2 = entrySet;
                        this.val$it = iterator;
                        this.last = null;
                    }

                    public boolean hasNext() {
                        return this.val$it.hasNext();
                    }

                    public Map.Entry<K, V> next() {
                        this.last = (Node)this.val$it.next();
                        return EntrySet.access$100(this.this$2).new NodeWrapper(this.last);
                    }

                    public void remove() {
                        if (this.last == null) {
                            throw new IllegalStateException();
                        }
                        EntrySet.access$100(this.this$2).removeFast(this.last.getKey());
                        this.last = null;
                    }

                    public /* synthetic */ Object next() {
                        return this.next();
                    }
                };
            }

            @Override
            public /* synthetic */ boolean add(Object x0) {
                return super.add((Map.Entry)x0);
            }

            @Override
            public /* synthetic */ Map asMap() {
                return this.asMap();
            }

            static /* synthetic */ MapImpl access$100(EntrySet x0) {
                return x0.MapImpl.this;
            }
        }
    }
}

