/*
 * Decompiled with CFR 0.152.
 */
package net.cscott.jutil;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.cscott.jutil.Default;
import net.cscott.jutil.PersistentMap;
import net.cscott.jutil.PersistentTreeNode;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentMap<K, V>
implements Serializable {
    final Node<K, V> root;
    final Comparator<K> c;
    final Node.Allocator<K, V> allocator;

    public PersistentMap() {
        this(Default.comparator);
    }

    public PersistentMap(Comparator<K> c) {
        this(null, c, new Node.Allocator());
    }

    private PersistentMap(Node<K, V> root, Comparator<K> c, Node.Allocator<K, V> allocator) {
        this.root = root;
        this.c = c;
        this.allocator = allocator;
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    public int size() {
        return this.root == null ? 0 : this.root.size;
    }

    public PersistentMap<K, V> put(K key, V value) {
        Node<K, V> new_root = Node.put(this.root, this.c, key, value, this.allocator);
        return this.root == new_root ? this : new PersistentMap<K, V>(new_root, this.c, this.allocator);
    }

    public V get(K key) {
        Node<K, V> np = Node.get(this.root, this.c, key);
        return np == null ? null : (V)np.value;
    }

    public boolean containsKey(K key) {
        return Node.get(this.root, this.c, key) != null;
    }

    public PersistentMap<K, V> remove(K key) {
        Node<K, V> new_root = Node.remove(this.root, this.c, key, this.allocator);
        return this.root == new_root ? this : new PersistentMap<K, V>(new_root, this.c, this.allocator);
    }

    public PersistentMap<K, V> putAll(PersistentMap<K, V> map) {
        if (((Object)this.c).equals(map.c) && this.allocator == map.allocator) {
            Node<K, V> new_root = Node.putAll(this.root, map.root, this.c, this.allocator);
            return new_root == this.root ? this : (new_root == map.root ? map : new PersistentMap<K, V>(new_root, this.c, this.allocator));
        }
        Node<K, V> new_root = this.root;
        Iterator<Node<K, V>> it = Node.iterator(map.root);
        while (it.hasNext()) {
            Node<K, V> n = it.next();
            new_root = Node.put(new_root, this.c, n.key, n.value, this.allocator);
        }
        return this.root == new_root ? this : new PersistentMap<K, V>(new_root, this.c, this.allocator);
    }

    public PersistentMap<K, V> clone() {
        return new PersistentMap<K, V>(this.root, this.c, this.allocator);
    }

    public String toString() {
        return this.asMap().toString();
    }

    public int hashCode() {
        return this.root == null ? 0 : this.root.mapHashCode;
    }

    public Map<K, V> asMap() {
        return new AbstractMap<K, V>(){

            @Override
            public Map<K, V> clone() {
                return PersistentMap.this.asMap();
            }

            @Override
            public boolean containsKey(Object key) {
                return PersistentMap.this.containsKey(key);
            }

            @Override
            public V get(Object key) {
                return PersistentMap.this.get(key);
            }

            @Override
            public boolean isEmpty() {
                return PersistentMap.this.isEmpty();
            }

            @Override
            public int size() {
                return PersistentMap.this.size();
            }

            @Override
            public Set<Map.Entry<K, V>> entrySet() {
                return new AbstractSet<Map.Entry<K, V>>(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public int size() {
                        return 1.access$000(this.this$1).size();
                    }

                    public Iterator<Map.Entry<K, V>> iterator() {
                        Iterator<Node<K, V>> it = Node.iterator(1.access$000(this.this$1).root);
                        return new Iterator<Map.Entry<K, V>>(){
                            Node<K, V> last;
                            private final /* synthetic */ Iterator val$it;
                            private final /* synthetic */ 2 this$2;
                            {
                                this.this$2 = var1_1;
                                this.val$it = iterator;
                                this.last = null;
                            }

                            public boolean hasNext() {
                                return this.val$it.hasNext();
                            }

                            public Map.Entry<K, V> next() {
                                this.last = (Node)this.val$it.next();
                                return this.last;
                            }

                            public void remove() {
                                if (this.last == null) {
                                    throw new IllegalStateException();
                                }
                                1.access$000(2.access$100(this.this$2)).remove(this.last.getKey());
                                this.last = null;
                            }

                            public /* synthetic */ Object next() {
                                return this.next();
                            }
                        };
                    }

                    public /* synthetic */ boolean add(Object x0) {
                        return super.add((Map.Entry)x0);
                    }

                    static /* synthetic */ 1 access$100(2 x0) {
                        return x0.this$1;
                    }
                };
            }

            @Override
            public /* synthetic */ Object clone() throws CloneNotSupportedException {
                return this.clone();
            }

            static /* synthetic */ PersistentMap access$000(1 x0) {
                return x0.PersistentMap.this;
            }
        };
    }

    public /* synthetic */ Object clone() throws CloneNotSupportedException {
        return this.clone();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node<K, V>
    extends PersistentTreeNode<Node<K, V>, K, V>
    implements Serializable {
        final V value;
        final int mapHashCode;
        final int size;

        Node(K key, V value, Node<K, V> left, Node<K, V> right) {
            super(key, left, right);
            this.value = value;
            this.mapHashCode = this.hashCode() + (left == null ? 0 : left.mapHashCode) + (right == null ? 0 : right.mapHashCode);
            this.size = 1 + (left == null ? 0 : left.size) + (right == null ? 0 : right.size);
        }

        @Override
        public V getValue() {
            return this.value;
        }

        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class Allocator<K, V>
        extends PersistentTreeNode.Allocator<Node<K, V>, K, V>
        implements Serializable {
            Allocator() {
            }

            @Override
            Node<K, V> newNode(K key, V value, Node<K, V> left, Node<K, V> right) {
                return new Node<K, V>(key, value, left, right);
            }

            @Override
            /* synthetic */ PersistentTreeNode newNode(Object x0, Object x1, PersistentTreeNode x2, PersistentTreeNode x3) {
                return this.newNode(x0, x1, (Node)x2, (Node)x3);
            }
        }
    }
}

