/*
 * Decompiled with CFR 0.152.
 */
package net.cscott.jutil;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.cscott.jutil.Environment;
import net.cscott.jutil.PersistentMap;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentEnvironment<K, V>
extends AbstractMap<K, V>
implements Environment<K, V> {
    PersistentMap<K, V> m = new PersistentMap();

    public PersistentEnvironment() {
    }

    public <K2 extends K, V2 extends V> PersistentEnvironment(Map<K2, V2> m) {
        this.putAll(m);
    }

    @Override
    public void clear() {
        this.m = new PersistentMap();
    }

    @Override
    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    @Override
    public int size() {
        return this.m.size();
    }

    @Override
    public V get(Object key) {
        return this.m.get(key);
    }

    @Override
    public V put(K key, V value) {
        V prev = this.m.get(key);
        this.m = this.m.put(key, value);
        return prev;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.m.containsKey(key);
    }

    @Override
    public V remove(Object key) {
        Object k = key;
        V prev = this.m.get(k);
        this.m = this.m.remove(k);
        return prev;
    }

    @Override
    public Environment.Mark getMark() {
        return new Mark<K, V>(this.m);
    }

    @Override
    public void undoToMark(Environment.Mark m) {
        this.m = ((Mark)m).m;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableSet(this.m.asMap().entrySet());
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Mark<K, V>
    implements Environment.Mark {
        final PersistentMap<K, V> m;

        Mark(PersistentMap<K, V> m) {
            this.m = m;
        }
    }
}

