/*
 * Decompiled with CFR 0.152.
 */
package net.cscott.jutil;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.cscott.jutil.Factories;
import net.cscott.jutil.ListFactory;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinearSet<E>
extends AbstractSet<E>
implements Cloneable,
Serializable {
    private List<E> list;
    private ListFactory<E> lf;

    public LinearSet() {
        this(Factories.arrayListFactory());
    }

    public LinearSet(int capacity) {
        this(Factories.arrayListFactory(), capacity);
    }

    public LinearSet(Set<? extends E> set) {
        this(Factories.arrayListFactory(), set);
    }

    public LinearSet(Collection<? extends E> c) {
        this(Factories.arrayListFactory());
        this.addAll(c);
    }

    public LinearSet(ListFactory<E> lf) {
        this.list = lf.makeList();
        this.lf = lf;
    }

    public LinearSet(ListFactory<E> lf, int capacity) {
        this.list = lf.makeList(capacity);
        this.lf = lf;
    }

    public LinearSet(ListFactory<E> lf, Set<? extends E> set) {
        this.list = lf.makeList(set);
        this.lf = lf;
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean add(E o) {
        if (this.list.contains(o)) {
            return false;
        }
        this.list.add(o);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        HashSet<E> s = new HashSet<E>(this.size() + c.size());
        s.addAll(this);
        boolean r = s.addAll(c);
        this.list = this.lf.makeList(s);
        return r;
    }

    @Override
    public boolean remove(Object o) {
        int index = this.list.indexOf(o);
        if (index == -1) {
            return false;
        }
        this.list.remove(index);
        return true;
    }

    public LinearSet<E> clone() {
        return new LinearSet<E>(this);
    }

    public /* synthetic */ Object clone() throws CloneNotSupportedException {
        return this.clone();
    }
}

