/*
 * Decompiled with CFR 0.152.
 */
package net.cscott.jutil;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.cscott.jutil.LinearSet;
import net.cscott.jutil.PairMapEntry;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinearMap<K, V>
extends AbstractMap<K, V> {
    private LinearSet<Map.Entry<K, V>> set;

    public LinearMap() {
        this.set = new LinearSet();
    }

    public LinearMap(Map<K, V> map) {
        this.set = new LinearSet<Map.Entry<K, V>>(map.entrySet());
    }

    public LinearMap(int capacity) {
        this.set = new LinearSet(capacity);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public int size() {
                return LinearMap.this.set.size();
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return LinearMap.this.set.iterator();
            }

            @Override
            public /* synthetic */ boolean add(Object x0) {
                return super.add((Map.Entry)x0);
            }
        };
    }

    @Override
    public V put(K key, V value) {
        Iterator<Map.Entry<K, V>> entries = this.set.iterator();
        V oldValue = null;
        while (entries.hasNext()) {
            Map.Entry<K, V> entry = entries.next();
            if (!this.keysMatch(key, entry.getKey())) continue;
            oldValue = entry.getValue();
            entry.setValue(value);
            return oldValue;
        }
        this.set.add(new PairMapEntry<K, V>(key, value));
        return oldValue;
    }

    private boolean keysMatch(Object k1, K k2) {
        return k1 == null && k2 == null || k1 != null && k2 != null && k1.equals(k2);
    }

    @Override
    public V remove(Object key) {
        Iterator<Map.Entry<K, V>> entries = this.set.iterator();
        V oldValue = null;
        while (entries.hasNext()) {
            Map.Entry<K, V> entry = entries.next();
            if (!this.keysMatch(key, entry.getKey())) continue;
            oldValue = entry.getValue();
            this.set.remove(entry);
            break;
        }
        return oldValue;
    }
}

