/*
 * Decompiled with CFR 0.152.
 */
package net.cscott.jutil;

import java.util.Comparator;
import java.util.Iterator;
import net.cscott.jutil.BinaryTree;
import net.cscott.jutil.CombineIterator;
import net.cscott.jutil.Default;
import net.cscott.jutil.RedBlackTree;

public class IntervalTree
extends RedBlackTree {
    protected BinaryTree.Node makeNode(Object o) {
        return new IntervalNode(o);
    }

    protected BinaryTree.Node setLeft(BinaryTree.Node p, BinaryTree.Node l) {
        BinaryTree.Node n = super.setLeft(p, l);
        this.fixMax(p);
        return n;
    }

    protected BinaryTree.Node setRight(BinaryTree.Node p, BinaryTree.Node r) {
        BinaryTree.Node n = super.setRight(p, r);
        this.fixMax(p);
        return n;
    }

    protected BinaryTree.Node setParent(BinaryTree.Node c, BinaryTree.Node p) {
        BinaryTree.Node n = super.setParent(c, p);
        this.fixMax(p);
        return n;
    }

    private void fixMax(BinaryTree.Node p) {
        if (p == this.NIL) {
            return;
        }
        if (p.left() == this.NIL || p.right() == this.NIL) {
            this.setMax(p, this.interval((BinaryTree.Node)p).high);
        } else {
            this.setMax(p, Math.max(this.max(p.left()), this.max(p.right())));
        }
    }

    private void setMax(BinaryTree.Node n, int m) {
        ((IntervalNode)n).max = m;
    }

    private Interval interval(BinaryTree.Node n) {
        return (Interval)n.key;
    }

    private int max(BinaryTree.Node n) {
        return ((IntervalNode)n).max;
    }

    public IntervalTree() {
        super(Interval.COMPARE);
    }

    public Interval searchOverlapping(Interval i) {
        return this.searchOverlapping(this.root(), i);
    }

    private Interval searchOverlapping(BinaryTree.Node x, Interval i) {
        while (x != this.NIL && !i.overlaps(this.interval(x))) {
            if (x.left() != this.NIL && this.max(x.left()) >= i.low) {
                x = x.left();
                continue;
            }
            x = x.right();
        }
        if (x == this.NIL) {
            return null;
        }
        return this.interval(x);
    }

    public Iterator allOverlapping(Interval i) {
        return this.allOverlapping(this.root(), i);
    }

    private Iterator allOverlapping(BinaryTree.Node x, Interval i) {
        if (x == this.NIL) {
            return Default.nullIterator;
        }
        if (this.interval(x).overlaps(i)) {
            return new CombineIterator<Interval>(Default.singletonIterator(this.interval(x)), this.allOverlapping(x.left(), i), this.allOverlapping(x.right(), i));
        }
        if (x.left() != this.NIL && this.max(x.left()) >= i.low) {
            return new CombineIterator(this.allOverlapping(x.left(), i), this.allOverlapping(x.right(), i));
        }
        return this.allOverlapping(x.right(), i);
    }

    public Interval addInterval(Object datum, int low, int high) {
        Interval i = new Interval(datum, low, high);
        this.add(i);
        return i;
    }

    public static void main(String[] args) {
        IntervalTree t = new IntervalTree();
        IntervalTree.addTestIval(t, 0, 3);
        IntervalTree.addTestIval(t, 5, 8);
        IntervalTree.addTestIval(t, 15, 23);
        IntervalTree.addTestIval(t, 6, 10);
        IntervalTree.addTestIval(t, 16, 21);
        IntervalTree.addTestIval(t, 8, 9);
        IntervalTree.addTestIval(t, 17, 19);
        IntervalTree.addTestIval(t, 25, 30);
        IntervalTree.addTestIval(t, 19, 20);
        IntervalTree.addTestIval(t, 26, 26);
        System.out.println(t.dump());
        IntervalTree.testSearchOverlap(t, 22, 25);
        IntervalTree.testSearchOverlap(t, 11, 14);
    }

    private static void addTestIval(IntervalTree t, int low, int high) {
        t.addInterval(low + "-" + high, low, high);
    }

    private static void testSearchOverlap(IntervalTree t, int low, int high) {
        System.out.println("overlaps " + low + "-" + high + " : " + t.searchOverlapping(new Interval(null, low, high)));
    }

    private class IntervalNode
    extends RedBlackTree.RBNode {
        protected int max;

        IntervalNode(Object o) {
            super(IntervalTree.this, o);
            Interval i = (Interval)o;
            if (i != null) {
                this.max = i.high;
            }
        }
    }

    public static class Interval {
        static Comparator COMPARE = new Comparator(){

            public int compare(Object a, Object b) {
                return ((Interval)a).low - ((Interval)b).low;
            }
        };
        public final int low;
        public final int high;
        public final Object datum;

        public Interval(Object datum, int low, int high) {
            this.low = low;
            this.high = high;
            this.datum = datum;
        }

        public boolean overlaps(Interval i) {
            return this.low <= i.high && this.high >= i.low;
        }
    }
}

