/*
 * Decompiled with CFR 0.152.
 */
package net.cscott.jutil;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.cscott.jutil.AbstractMapEntry;
import net.cscott.jutil.Environment;
import net.cscott.jutil.FilterIterator;
import net.cscott.jutil.HashEnvironment;
import net.cscott.jutil.MapSet;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashEnvironment<K, V>
extends AbstractMap<K, V>
implements Environment<K, V> {
    final Map<K, LList<V>> back = new HashMap<K, LList<V>>();
    final List<K> scope = new ArrayList<K>();
    int size = 0;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$net$cscott$jutil$HashEnvironment;

    public HashEnvironment() {
    }

    public HashEnvironment(Map<? extends K, ? extends V> m) {
        this();
        this.putAll(m);
    }

    @Override
    public boolean containsKey(Object key) {
        LList<V> l = this.back.get(key);
        return l == null ? false : l.hasValue();
    }

    @Override
    public V get(Object key) {
        LList<V> l = this.back.get(key);
        return l == null ? null : (V)l.getValue();
    }

    @Override
    public V put(K key, V value) {
        LList<V> l = this.back.get(key);
        this.back.put(key, new Valued<V>(value, l));
        this.scope.add(key);
        if (l == null || !l.hasValue()) {
            ++this.size;
            return null;
        }
        return l.getValue();
    }

    @Override
    public V remove(Object key) {
        LList<V> l = this.back.get(key);
        if (l == null || !l.hasValue()) {
            return null;
        }
        Object k = key;
        this.back.put(k, new NoValue<V>(l));
        this.scope.add(k);
        --this.size;
        return l.getValue();
    }

    void pop(K key) {
        LList<V> l = this.back.get(key);
        if (!$assertionsDisabled && l == null) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || l instanceof Valued || l.next instanceof Valued)) {
            throw new AssertionError();
        }
        if (l.next == null) {
            this.back.remove(key);
        } else {
            this.back.put(key, l.next);
        }
        if (l.hasValue()) {
            --this.size;
        }
        if (l.next != null && l.next.hasValue()) {
            ++this.size;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        for (Object k : this.keySet()) {
            this.remove(k);
        }
    }

    @Override
    public Environment.Mark getMark() {
        return new Mark(this.scope.size());
    }

    @Override
    public void undoToMark(Environment.Mark m) {
        int i = ((Mark)m).i;
        while (this.scope.size() > i) {
            this.pop(this.scope.get(this.scope.size() - 1));
            this.scope.remove(this.scope.size() - 1);
        }
        if (!$assertionsDisabled && this.scope.size() != ((Mark)m).i) {
            throw new AssertionError((Object)"undoToMark not repeatable!");
        }
    }

    public MapSet<K, V> entrySet() {
        return new AbstractMapSet<K, V>(){

            @Override
            public int size() {
                return HashEnvironment.this.size;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new FilterIterator(HashEnvironment.this.back.entrySet().iterator(), new FilterIterator.Filter<Map.Entry<K, LList<V>>, Map.Entry<K, V>>(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public boolean isElement(Map.Entry<K, LList<V>> e) {
                        return e.getValue().hasValue();
                    }

                    public Map.Entry<K, V> map(Map.Entry<K, LList<V>> e) {
                        return new AbstractMapEntry<K, V>(){
                            private final /* synthetic */ Map.Entry val$e;
                            private final /* synthetic */ 2 this$2;
                            {
                                this.this$2 = var1_1;
                                this.val$e = entry;
                            }

                            public K getKey() {
                                return this.val$e.getKey();
                            }

                            public V getValue() {
                                return (V)((LList)this.val$e.getValue()).getValue();
                            }
                        };
                    }

                    public /* synthetic */ Object map(Object x0) {
                        return this.map((Map.Entry)x0);
                    }

                    public /* synthetic */ boolean isElement(Object x0) {
                        return this.isElement((Map.Entry)x0);
                    }
                });
            }

            @Override
            public HashEnvironment<K, V> asMap() {
                return HashEnvironment.this;
            }

            @Override
            public /* synthetic */ Map asMap() {
                return this.asMap();
            }
        };
    }

    public static void main(String[] argv) {
        HashEnvironment<String, String> e = new HashEnvironment<String, String>();
        if (!$assertionsDisabled && (e.size() != 0 || e.containsKey("a") || e.containsKey("b"))) {
            throw new AssertionError();
        }
        e.put("a", "a");
        e.put("a", "b");
        if (!($assertionsDisabled || e.size() == 1 && e.containsKey("a") && e.containsValue("b"))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && (e.containsValue("a") || e.containsValue("c"))) {
            throw new AssertionError();
        }
        Environment.Mark m = e.getMark();
        e.remove("a");
        e.remove("a");
        if (!$assertionsDisabled && (e.size() != 0 || e.containsKey("a"))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && (e.containsKey("b") || e.containsValue("b"))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && e.containsValue("a")) {
            throw new AssertionError();
        }
        e.put("b", "b");
        e.put("b", "c");
        if (!($assertionsDisabled || e.size() == 1 && e.containsKey("b"))) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || !e.containsKey("a") && e.containsValue("c"))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && e.containsValue("b")) {
            throw new AssertionError();
        }
        System.out.println(e);
        e.undoToMark(m);
        if (!($assertionsDisabled || e.size() == 1 && e.containsKey("a") && !e.containsKey("b"))) {
            throw new AssertionError();
        }
        System.out.println(e);
        e.put("c", "d");
        e.put("c", "d");
        if (!($assertionsDisabled || e.size() == 2 && e.containsKey("c") && e.containsValue("d"))) {
            throw new AssertionError();
        }
        m = e.getMark();
        e.clear();
        if (!$assertionsDisabled && (e.size() != 0 || e.containsKey("a") || e.containsKey("b"))) {
            throw new AssertionError();
        }
        e.undoToMark(m);
        if (!($assertionsDisabled || e.size() == 2 && e.containsKey("c") && e.containsValue("d"))) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || e.containsKey("a") && !e.containsKey("b"))) {
            throw new AssertionError();
        }
        System.out.println(e);
    }

    @Override
    public /* synthetic */ Set entrySet() {
        return this.entrySet();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$net$cscott$jutil$HashEnvironment == null ? (class$net$cscott$jutil$HashEnvironment = HashEnvironment.class$("net.cscott.jutil.HashEnvironment")) : class$net$cscott$jutil$HashEnvironment).desiredAssertionStatus();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Valued<T>
    extends LList<T> {
        final T value;

        Valued(T value, LList<T> next) {
            super(next);
            this.value = value;
        }

        @Override
        boolean hasValue() {
            return true;
        }

        @Override
        T getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NoValue<T>
    extends LList<T> {
        NoValue(LList<T> next) {
            super(next);
        }

        @Override
        boolean hasValue() {
            return false;
        }

        @Override
        T getValue() {
            return null;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class LList<T> {
        final LList<T> next;

        LList(LList<T> next) {
            this.next = next;
        }

        abstract boolean hasValue();

        abstract T getValue();
    }

    private static class Mark
    implements Environment.Mark {
        final int i;

        Mark(int i) {
            this.i = i;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class AbstractMapSet<K, V>
    extends AbstractSet<Map.Entry<K, V>>
    implements MapSet<K, V> {
        AbstractMapSet() {
        }

        @Override
        public /* synthetic */ boolean add(Object x0) {
            return super.add((Map.Entry)x0);
        }
    }
}

