/*
 * Decompiled with CFR 0.152.
 */
package net.cscott.jutil;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.cscott.jutil.CollectionFactory;
import net.cscott.jutil.Default;
import net.cscott.jutil.Factories;
import net.cscott.jutil.GenericMultiMap;
import net.cscott.jutil.MapFactory;
import net.cscott.jutil.MultiMap;
import net.cscott.jutil.MultiMapSet;
import net.cscott.jutil.PairMapEntry;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericMultiMap<K, V>
implements MultiMap<K, V> {
    private Map<K, Collection<V>> internMap;
    private CollectionFactory<V> cf;
    private MapFactory<K, Collection<V>> mf;
    private final Set<K> keySet = new KeySet();
    private final Collection<V> valuesCollection = new ValuesCollection();
    private final MultiMapSet<K, V> entrySet = new EntrySet();

    public GenericMultiMap() {
        this(Factories.hashMapFactory(), Factories.hashSetFactory());
    }

    public GenericMultiMap(CollectionFactory<V> cf) {
        this(Factories.hashMapFactory(), cf);
    }

    public GenericMultiMap(MapFactory<K, Collection<V>> mf, CollectionFactory<V> cf) {
        this.internMap = mf.makeMap();
        this.cf = cf;
        this.mf = mf;
    }

    GenericMultiMap(GenericMultiMap<K, V> mm) {
        this.mf = mm.mf;
        this.cf = mm.cf;
        this.internMap = this.mf.makeMap(mm.internMap);
    }

    GenericMultiMap(Map<? extends K, ? extends V> m) {
        this();
        this.putAll(m);
    }

    @Override
    public int size() {
        int count = 0;
        for (Collection<V> c : this.internMap.values()) {
            count += c.size();
        }
        return count;
    }

    @Override
    public boolean isEmpty() {
        for (Collection<V> c : this.internMap.values()) {
            if (c.size() <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object key) {
        Collection<V> s = this.internMap.get(key);
        return s != null && s.size() != 0;
    }

    @Override
    public boolean containsValue(Object value) {
        for (K k : this.internMap.keySet()) {
            if (!this.getValues(k).contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        Collection<V> s = this.internMap.get(key);
        if (s == null || s.size() == 0) {
            return null;
        }
        return s.iterator().next();
    }

    @Override
    public V put(K key, V value) {
        Collection<V> c = this.getValues(key);
        V prev = c.size() == 0 ? null : (V)c.iterator().next();
        c.clear();
        c.add(value);
        return prev;
    }

    @Override
    public V remove(Object key) {
        Collection<V> c = this.internMap.get(key);
        this.internMap.remove(key);
        return c == null || c.size() == 0 ? null : (V)c.iterator().next();
    }

    @Override
    public boolean remove(Object key, Object value) {
        boolean result;
        Collection<V> c = this.internMap.get(key);
        boolean bl = result = c != null ? c.remove(value) : false;
        if (c != null && c.size() == 0) {
            this.internMap.remove(key);
        }
        return result;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        for (Map.Entry<K, V> e : t.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        this.internMap.clear();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        try {
            Set entrySet = ((Map)o).entrySet();
            return ((Object)this.entrySet()).equals(entrySet);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        Iterator entries = this.entrySet().iterator();
        int sum = 0;
        while (entries.hasNext()) {
            sum += ((Object)((Map.Entry)entries.next())).hashCode();
        }
        return sum;
    }

    @Override
    public boolean add(K key, V value) {
        boolean changed = this.getValues(key).add(value);
        return changed;
    }

    @Override
    public boolean addAll(K key, Collection<? extends V> values) {
        return this.getValues(key).addAll(values);
    }

    @Override
    public boolean addAll(MultiMap<? extends K, ? extends V> mm) {
        boolean changed = false;
        for (Map.Entry entry : mm.entrySet()) {
            if (!this.add(entry.getKey(), entry.getValue())) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(K key, Collection<?> values) {
        return this.getValues(key).retainAll(values);
    }

    @Override
    public boolean removeAll(K key, Collection<?> values) {
        return this.getValues(key).removeAll(values);
    }

    @Override
    public Collection<V> getValues(K key) {
        Collection<V> c = this.internMap.get(key);
        if (c == null) {
            c = this.cf.makeCollection();
            this.internMap.put(key, c);
        }
        return c;
    }

    @Override
    public boolean contains(Object a, Object b) {
        Collection<V> c = this.internMap.get(a);
        if (c != null) {
            return c.contains(b);
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (K k : this.keySet()) {
            Collection<V> values = this.getValues(k);
            if (values.size() == 0) continue;
            sb.append(new StringBuffer().append("< ").append(k).append(" -> ").append(values).append(" > ").toString());
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Set<K> keySet() {
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        return this.valuesCollection;
    }

    @Override
    public MultiMapSet<K, V> entrySet() {
        return this.entrySet;
    }

    @Override
    public /* synthetic */ Set entrySet() {
        return this.entrySet();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EntrySet
    extends AbstractCollection<Map.Entry<K, V>>
    implements MultiMapSet<K, V> {
        EntrySet() {
        }

        @Override
        public GenericMultiMap<K, V> asMap() {
            return this.asMultiMap();
        }

        @Override
        public GenericMultiMap<K, V> asMultiMap() {
            return GenericMultiMap.this;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Set && ((Set)o).size() == this.size()) {
                return this.containsAll((Collection)o);
            }
            return false;
        }

        @Override
        public int hashCode() {
            Iterator itr = this.iterator();
            int size = this.size();
            int hash = 0;
            for (int pos = 0; pos < size; ++pos) {
                Map.Entry obj = itr.next();
                if (obj == null) continue;
                hash += ((Object)obj).hashCode();
            }
            return hash;
        }

        @Override
        public int size() {
            return GenericMultiMap.this.size();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(this){
                Iterator<Map.Entry<K, Collection<V>>> mapit;
                Iterator<V> setit;
                Iterator<V> lastit;
                K key;
                private final /* synthetic */ EntrySet this$1;
                {
                    this.this$1 = entrySet;
                    this.mapit = GenericMultiMap.access$000(EntrySet.access$400(this.this$1)).entrySet().iterator();
                    this.setit = Default.nullIterator;
                    this.advance();
                }

                public boolean hasNext() {
                    return this.setit.hasNext();
                }

                public Map.Entry<K, V> next() {
                    V o = this.setit.next();
                    K k = this.key;
                    this.advance();
                    return new PairMapEntry<K, V>(this, k, o){
                        private final /* synthetic */ 3 this$2;
                        {
                            this.this$2 = var1_1;
                            super(x0, x1);
                        }

                        public V setValue(V newValue) {
                            V oldValue = this.getValue();
                            EntrySet.access$400(3.access$500(this.this$2)).remove(this.getKey(), oldValue);
                            EntrySet.access$400(3.access$500(this.this$2)).add(this.getKey(), newValue);
                            super.setValue(newValue);
                            return oldValue;
                        }
                    };
                }

                void advance() {
                    this.lastit = this.setit;
                    while (!this.setit.hasNext() && this.mapit.hasNext()) {
                        Map.Entry<K, Collection<V>> me = this.mapit.next();
                        this.key = me.getKey();
                        Collection<V> c = me.getValue();
                        this.setit = c.iterator();
                    }
                }

                public void remove() {
                    this.lastit.remove();
                }

                public /* synthetic */ Object next() {
                    return this.next();
                }

                static /* synthetic */ EntrySet access$500(3 x0) {
                    return x0.this$1;
                }
            };
        }

        @Override
        public boolean add(Map.Entry<K, V> me) {
            return GenericMultiMap.this.add(me.getKey(), me.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry me = (Map.Entry)o;
            return GenericMultiMap.this.remove(me.getKey(), me.getValue());
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry me = (Map.Entry)o;
            return GenericMultiMap.this.contains(me.getKey(), me.getValue());
        }

        @Override
        public void clear() {
            GenericMultiMap.this.clear();
        }

        @Override
        public /* synthetic */ boolean add(Object x0) {
            return this.add((Map.Entry)x0);
        }

        @Override
        public /* synthetic */ MultiMap asMultiMap() {
            return this.asMultiMap();
        }

        @Override
        public /* synthetic */ MultiMap asMap() {
            return this.asMap();
        }

        @Override
        public /* synthetic */ Map asMap() {
            return this.asMap();
        }

        static /* synthetic */ GenericMultiMap access$400(EntrySet x0) {
            return x0.GenericMultiMap.this;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ValuesCollection
    extends AbstractCollection<V> {
        ValuesCollection() {
        }

        @Override
        public int size() {
            return GenericMultiMap.this.entrySet.size();
        }

        @Override
        public Iterator<V> iterator() {
            return new Iterator<V>(this){
                final Iterator<Map.Entry<K, V>> it;
                private final /* synthetic */ ValuesCollection this$1;
                {
                    this.this$1 = valuesCollection;
                    this.it = GenericMultiMap.access$200(ValuesCollection.access$300(this.this$1)).iterator();
                }

                public boolean hasNext() {
                    return this.it.hasNext();
                }

                public V next() {
                    return this.it.next().getValue();
                }

                public void remove() {
                    this.it.remove();
                }
            };
        }

        @Override
        public boolean add(V o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            return GenericMultiMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            GenericMultiMap.this.entrySet.clear();
        }

        static /* synthetic */ GenericMultiMap access$300(ValuesCollection x0) {
            return x0.GenericMultiMap.this;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public int size() {
            return GenericMultiMap.this.internMap.keySet().size();
        }

        @Override
        public Iterator<K> iterator() {
            return new Iterator<K>(this){
                Iterator<K> it;
                K lastKey;
                private final /* synthetic */ KeySet this$1;
                {
                    this.this$1 = keySet;
                    this.it = GenericMultiMap.access$000(KeySet.access$100(this.this$1)).keySet().iterator();
                }

                public boolean hasNext() {
                    return this.it.hasNext();
                }

                public K next() {
                    this.lastKey = this.it.next();
                    return this.lastKey;
                }

                public void remove() {
                    Collection c = (Collection)GenericMultiMap.access$000(KeySet.access$100(this.this$1)).get(this.lastKey);
                    this.it.remove();
                }
            };
        }

        @Override
        public boolean remove(Object o) {
            boolean changed = this.contains(o);
            GenericMultiMap.this.remove(o);
            return changed;
        }

        @Override
        public boolean contains(Object o) {
            return GenericMultiMap.this.internMap.containsKey(o);
        }

        @Override
        public void clear() {
            GenericMultiMap.this.clear();
        }

        static /* synthetic */ GenericMultiMap access$100(KeySet x0) {
            return x0.GenericMultiMap.this;
        }
    }
}

