/*
 * Decompiled with CFR 0.152.
 */
package net.cscott.jutil;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.cscott.jutil.CollectionFactory;
import net.cscott.jutil.Factories;
import net.cscott.jutil.GenericMultiMap;
import net.cscott.jutil.InvertibleMultiMap;
import net.cscott.jutil.MapFactory;
import net.cscott.jutil.MultiMap;
import net.cscott.jutil.MultiMapFactory;
import net.cscott.jutil.MultiMapSet;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericInvertibleMultiMap<K, V>
implements InvertibleMultiMap<K, V> {
    private final MultiMap<K, V> map;
    private final MultiMap<V, K> imap;
    private final InvertibleMultiMap<V, K> inverse;

    private GenericInvertibleMultiMap(MultiMap<K, V> map, MultiMap<V, K> imap, InvertibleMultiMap<V, K> inverse) {
        this.map = map;
        this.imap = imap;
        this.inverse = inverse;
    }

    private GenericInvertibleMultiMap(MultiMap<K, V> map, MultiMap<V, K> imap) {
        this.map = map;
        this.imap = imap;
        this.inverse = new GenericInvertibleMultiMap<V, K>(imap, map, this);
    }

    public GenericInvertibleMultiMap(MultiMapFactory mmf) {
        this(mmf.makeMultiMap(), mmf.makeMultiMap());
    }

    public GenericInvertibleMultiMap(MapFactory mf, CollectionFactory cf) {
        this(new GenericMultiMap(mf, cf), new GenericMultiMap(mf, cf));
    }

    public GenericInvertibleMultiMap(CollectionFactory cf) {
        this(Factories.hashMapFactory, cf);
    }

    public GenericInvertibleMultiMap() {
        this(Factories.hashSetFactory);
    }

    public GenericInvertibleMultiMap(Map<? extends K, ? extends V> m) {
        this();
        this.putAll(m);
    }

    public GenericInvertibleMultiMap(MultiMap<? extends K, ? extends V> mm) {
        this();
        this.addAll(mm);
    }

    @Override
    public InvertibleMultiMap<V, K> invert() {
        return this.inverse;
    }

    @Override
    public boolean add(K key, V value) {
        this.imap.add(value, key);
        return this.map.add(key, value);
    }

    @Override
    public boolean addAll(K key, Collection<? extends V> values) {
        boolean changed = false;
        for (V v : values) {
            if (!this.add(key, v)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean addAll(MultiMap<? extends K, ? extends V> mm) {
        boolean changed = false;
        for (Map.Entry entry : mm.entrySet()) {
            if (!this.add(entry.getKey(), entry.getValue())) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        this.map.clear();
        this.imap.clear();
    }

    @Override
    public boolean contains(Object a, Object b) {
        return this.map.contains(a, b);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.imap.containsKey(value);
    }

    @Override
    public MultiMapSet<K, V> entrySet() {
        return new AbstractMultiMapSet<K, V>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                Iterator it = GenericInvertibleMultiMap.this.map.entrySet().iterator();
                return new Iterator<Map.Entry<K, V>>(){
                    Map.Entry<K, V> last;
                    private final /* synthetic */ Iterator val$it;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$it = iterator;
                    }

                    public boolean hasNext() {
                        return this.val$it.hasNext();
                    }

                    public Map.Entry<K, V> next() {
                        this.last = (Map.Entry)this.val$it.next();
                        return this.last;
                    }

                    public void remove() {
                        this.val$it.remove();
                        GenericInvertibleMultiMap.access$200(1.access$100(this.this$1)).remove(this.last.getValue(), this.last.getKey());
                    }

                    public /* synthetic */ Object next() {
                        return this.next();
                    }
                };
            }

            @Override
            public void clear() {
                GenericInvertibleMultiMap.this.clear();
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry me = (Map.Entry)o;
                return GenericInvertibleMultiMap.this.contains(me.getKey(), me.getValue());
            }

            @Override
            public int size() {
                return GenericInvertibleMultiMap.this.size();
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry me = (Map.Entry)o;
                return GenericInvertibleMultiMap.this.remove(me.getKey(), me.getValue());
            }

            @Override
            public MultiMap<K, V> asMap() {
                return this.asMultiMap();
            }

            @Override
            public MultiMap<K, V> asMultiMap() {
                return GenericInvertibleMultiMap.this;
            }

            @Override
            public /* synthetic */ Map asMap() {
                return this.asMap();
            }

            static /* synthetic */ GenericInvertibleMultiMap access$100(1 x0) {
                return x0.GenericInvertibleMultiMap.this;
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public Collection<V> getValues(final K key) {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                Iterator it = GenericInvertibleMultiMap.this.map.getValues(key).iterator();
                return new Iterator<V>(){
                    V last;
                    private final /* synthetic */ Iterator val$it;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$it = iterator;
                    }

                    public boolean hasNext() {
                        return this.val$it.hasNext();
                    }

                    public V next() {
                        this.last = this.val$it.next();
                        return this.last;
                    }

                    public void remove() {
                        GenericInvertibleMultiMap.access$200(3.access$400(this.this$1)).remove(this.last, 3.access$300(this.this$1));
                        this.val$it.remove();
                    }
                };
            }

            @Override
            public boolean add(V o) {
                return GenericInvertibleMultiMap.this.add(key, o);
            }

            @Override
            public void clear() {
                GenericInvertibleMultiMap.this.map.remove(key);
            }

            @Override
            public boolean contains(Object o) {
                return GenericInvertibleMultiMap.this.contains(key, o);
            }

            @Override
            public boolean remove(Object o) {
                return GenericInvertibleMultiMap.this.remove(key, o);
            }

            @Override
            public int size() {
                return GenericInvertibleMultiMap.this.map.getValues(key).size();
            }

            static /* synthetic */ Object access$300(3 x0) {
                return x0.key;
            }

            static /* synthetic */ GenericInvertibleMultiMap access$400(3 x0) {
                return x0.GenericInvertibleMultiMap.this;
            }
        };
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                Iterator it = GenericInvertibleMultiMap.this.map.keySet().iterator();
                return new Iterator<K>(){
                    K last;
                    private final /* synthetic */ Iterator val$it;
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$it = iterator;
                    }

                    public boolean hasNext() {
                        return this.val$it.hasNext();
                    }

                    public K next() {
                        this.last = this.val$it.next();
                        return this.last;
                    }

                    public void remove() {
                        for (V v : GenericInvertibleMultiMap.access$000(5.access$500(this.this$1)).getValues(this.last)) {
                            GenericInvertibleMultiMap.access$200(5.access$500(this.this$1)).remove(v, this.last);
                        }
                        this.val$it.remove();
                    }
                };
            }

            @Override
            public void clear() {
                GenericInvertibleMultiMap.this.clear();
            }

            @Override
            public boolean contains(Object o) {
                return GenericInvertibleMultiMap.this.containsKey(o);
            }

            @Override
            public int size() {
                return GenericInvertibleMultiMap.this.size();
            }

            @Override
            public boolean remove(Object o) {
                boolean changed = GenericInvertibleMultiMap.this.containsKey(o);
                GenericInvertibleMultiMap.this.remove(o);
                return changed;
            }

            static /* synthetic */ GenericInvertibleMultiMap access$500(5 x0) {
                return x0.GenericInvertibleMultiMap.this;
            }
        };
    }

    @Override
    public V put(K key, V value) {
        V old = this.remove(key);
        this.add(key, value);
        return old;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        for (Map.Entry<K, V> me : t.entrySet()) {
            this.put(me.getKey(), me.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        V old = null;
        Iterator<V> it = this.getValues(key).iterator();
        while (it.hasNext()) {
            old = it.next();
            it.remove();
        }
        return old;
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.imap.remove(value, key);
        return this.map.remove(key, value);
    }

    @Override
    public boolean removeAll(K key, Collection<?> values) {
        boolean changed = false;
        for (Object v : values) {
            if (!this.remove(key, v)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(K key, Collection<?> values) {
        boolean changed = false;
        Iterator<V> it = this.getValues(key).iterator();
        while (it.hasNext()) {
            if (values.contains(it.next())) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public Collection<V> values() {
        return this.inverse.keySet();
    }

    @Override
    public /* synthetic */ Set entrySet() {
        return this.entrySet();
    }

    @Override
    public /* synthetic */ MultiMap invert() {
        return this.invert();
    }

    static /* synthetic */ MultiMap access$200(GenericInvertibleMultiMap x0) {
        return x0.imap;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class AbstractMultiMapSet<K, V>
    extends AbstractSet<Map.Entry<K, V>>
    implements MultiMapSet<K, V> {
        AbstractMultiMapSet() {
        }

        @Override
        public /* synthetic */ boolean add(Object x0) {
            return super.add((Map.Entry)x0);
        }
    }
}

