/*
 * Decompiled with CFR 0.152.
 */
package net.cscott.jutil;

import java.util.Map;
import net.cscott.jutil.Factories;
import net.cscott.jutil.InvertibleMap;
import net.cscott.jutil.MapFactory;
import net.cscott.jutil.MapWrapper;
import net.cscott.jutil.MultiMap;
import net.cscott.jutil.MultiMapFactory;
import net.cscott.jutil.UnmodifiableMultiMap;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericInvertibleMap<K, V>
extends MapWrapper<K, V>
implements InvertibleMap<K, V> {
    private MultiMap<V, K> imap;

    public GenericInvertibleMap() {
        this(Factories.hashMapFactory(), new MultiMapFactory());
    }

    public GenericInvertibleMap(MapFactory<K, V> mf, MultiMapFactory<V, K> mmf) {
        super(mf.makeMap());
        this.imap = mmf.makeMultiMap();
    }

    public GenericInvertibleMap(Map<K, V> m) {
        this();
        this.putAll(m);
    }

    @Override
    public MultiMap<V, K> invert() {
        return UnmodifiableMultiMap.proxy(this.imap);
    }

    @Override
    public V put(K key, V value) {
        V old = super.put(key, value);
        this.imap.remove(old, key);
        this.imap.add(value, key);
        return old;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        super.putAll(m);
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.imap.add(e.getValue(), e.getKey());
        }
    }

    @Override
    public V remove(Object key) {
        Object r = super.remove(key);
        this.imap.remove(r, key);
        return r;
    }
}

