/*
 * Decompiled with CFR 0.152.
 */
package net.cscott.jutil;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import net.cscott.jutil.AbstractHeap;
import net.cscott.jutil.Heap;
import net.cscott.jutil.PairMapEntry;
import net.cscott.jutil.UnmodifiableIterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FibonacciHeap<K, V>
extends AbstractHeap<K, V> {
    private static final boolean debug = false;
    Node<K, V> min = null;
    int n = 0;
    int D = 0;
    final Comparator<Map.Entry<K, V>> c = this.entryComparator();
    private static final double phi;
    private static final double log_phi;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$net$cscott$jutil$FibonacciHeap;

    public FibonacciHeap() {
        this(Collections.EMPTY_SET, null);
    }

    public FibonacciHeap(Comparator<K> c) {
        this(Collections.EMPTY_SET, c);
    }

    public FibonacciHeap(Heap<K, ? extends V> h) {
        this(h.entries(), h.comparator());
    }

    public FibonacciHeap(Collection<? extends Map.Entry<? extends K, ? extends V>> collection, Comparator<K> comparator) {
        super(comparator);
        for (Map.Entry<K, V> e : collection) {
            this.insert(e.getKey(), e.getValue());
        }
    }

    @Override
    public Map.Entry<K, V> insert(K key, V value) {
        Entry<K, V> e = new Entry<K, V>(key, value);
        this.insert(e);
        return e;
    }

    @Override
    protected void insert(Map.Entry<K, V> me) {
        Node x = new Node((Entry)me);
        FibonacciHeap._concatenateListsContaining(x, this.min);
        if (this.min == null || this.c.compare(x.entry, this.min.entry) < 0) {
            this.min = x;
        }
        ++this.n;
    }

    @Override
    public Map.Entry<K, V> minimum() {
        if (this.min == null) {
            throw new NoSuchElementException();
        }
        return this.min.entry;
    }

    @Override
    public void union(FibonacciHeap<K, V> h) {
        FibonacciHeap._concatenateListsContaining(this.min, h.min);
        if (this.min == null || h.min != null && this.c.compare(h.min.entry, this.min.entry) < 0) {
            this.min = h.min;
        }
        this.n += h.n;
        h.clear();
    }

    @Override
    public void union(Heap<? extends K, ? extends V> h) {
        if (h instanceof FibonacciHeap && ((Object)this.entryComparator()).equals(((FibonacciHeap)h).entryComparator())) {
            this.union((FibonacciHeap)h);
        } else {
            super.union(h);
        }
    }

    @Override
    public Map.Entry<K, V> extractMinimum() {
        if (this.min == null) {
            throw new NoSuchElementException();
        }
        Node<K, V> z = this.min;
        Node x = z.child;
        if (x != null) {
            do {
                x.parent = null;
            } while ((x = x.right) != z.child);
        }
        FibonacciHeap._concatenateListsContaining(z.child, z);
        Node zRight = z.right;
        FibonacciHeap._removeFromList(z);
        if (z == zRight) {
            if (!$assertionsDisabled && this.n != 1) {
                throw new AssertionError();
            }
            this.min = null;
        } else {
            if (!$assertionsDisabled && this.n <= 1) {
                throw new AssertionError();
            }
            this.min = zRight;
            this._consolidate();
        }
        --this.n;
        return z.entry;
    }

    private void _consolidate() {
        ArrayList<Object> A = new ArrayList<Object>(Collections.nCopies(FibonacciHeap.D(this.n) + 1, null));
        Node w = this.min;
        while (w != null) {
            Node x = w;
            Node wR = w.right;
            FibonacciHeap._removeFromList(w);
            w = w == wR ? null : wR;
            int d = x.degree;
            while (A.get(d) != null) {
                Node y = A.get(d);
                if (this.c.compare(x.entry, y.entry) > 0) {
                    Node t = x;
                    x = y;
                    y = t;
                }
                this._link(y, x);
                A.set(d, null);
                ++d;
            }
            A.set(d, x);
        }
        this.min = null;
        for (int i = 0; i < A.size(); ++i) {
            if (A.get(i) == null) continue;
            if (!$assertionsDisabled && ((Node)A.get((int)i)).parent != null) {
                throw new AssertionError();
            }
            if (!($assertionsDisabled || ((Node)A.get((int)i)).left == A.get(i) && ((Node)A.get((int)i)).right == A.get(i))) {
                throw new AssertionError();
            }
            FibonacciHeap._concatenateListsContaining(this.min, A.get(i));
            if (this.min != null && this.c.compare(((Node)A.get((int)i)).entry, this.min.entry) >= 0) continue;
            this.min = A.get(i);
        }
    }

    private void _link(Node<K, V> y, Node<K, V> x) {
        if (!($assertionsDisabled || x.parent == null && y.parent == null)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || y.left == y && y.right == y)) {
            throw new AssertionError();
        }
        x.addChild(y);
        y.mark = false;
    }

    @Override
    public void decreaseKey(Map.Entry<K, V> me, K newkey) {
        this.decreaseKey((Entry)me, newkey, false);
    }

    private void decreaseKey(Entry<K, V> entry, K newkey, boolean delete) {
        if (!delete && this.keyComparator().compare(newkey, entry.getKey()) > 0) {
            throw new UnsupportedOperationException("New key is greater than current key.");
        }
        this.setKey(entry, newkey);
        Node x = entry.node;
        Node y = x.parent;
        if (y != null && (delete || this.c.compare(x.entry, y.entry) < 0)) {
            this._cut(x, y);
            this._cascadingCut(y);
        }
        if (delete || this.c.compare(x.entry, this.min.entry) < 0) {
            this.min = x;
        }
    }

    private void _cut(Node<K, V> x, Node<K, V> y) {
        y.removeChild(x);
        FibonacciHeap._concatenateListsContaining(x, this.min);
        x.parent = null;
        x.mark = false;
    }

    private void _cascadingCut(Node<K, V> y) {
        Node z = y.parent;
        if (z == null) {
            return;
        }
        if (!y.mark) {
            y.mark = true;
        } else {
            this._cut(y, z);
            this._cascadingCut(z);
        }
    }

    @Override
    public void delete(Map.Entry<K, V> me) {
        this.decreaseKey((Entry)me, null, true);
        this.extractMinimum();
    }

    @Override
    public int size() {
        return this.n;
    }

    @Override
    public void clear() {
        this.min = null;
        this.n = 0;
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        return new AbstractCollection<Map.Entry<K, V>>(){

            @Override
            public int size() {
                return FibonacciHeap.this.n;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new UnmodifiableIterator<Map.Entry<K, V>>(this){
                    Node<K, V> next;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                        this.next = 1.access$000(this.this$1).min;
                    }

                    public boolean hasNext() {
                        return this.next != null;
                    }

                    public Map.Entry<K, V> next() {
                        if (this.next == null) {
                            throw new NoSuchElementException();
                        }
                        Node<K, V> n = this.next;
                        this.next = FibonacciHeap.access$100(1.access$000(this.this$1), this.next);
                        return n.entry;
                    }

                    public /* synthetic */ Object next() {
                        return this.next();
                    }
                };
            }

            @Override
            public /* synthetic */ boolean add(Object x0) {
                return super.add((Map.Entry)x0);
            }

            static /* synthetic */ FibonacciHeap access$000(1 x0) {
                return x0.FibonacciHeap.this;
            }
        };
    }

    private Node<K, V> successor(Node<K, V> n) {
        if (!$assertionsDisabled && n == null) {
            throw new AssertionError();
        }
        if (n.child != null) {
            return n.child;
        }
        do {
            Node<K, V> first;
            Node<K, V> node = first = n.parent == null ? this.min : n.parent.child;
            if (!($assertionsDisabled || first != null && n.right != null)) {
                throw new AssertionError();
            }
            if (n.right == first) continue;
            return n.right;
        } while ((n = n.parent) != null);
        return null;
    }

    @Override
    protected final K setKey(Map.Entry<K, V> me, K newkey) {
        Entry e = (Entry)me;
        return e._setKey(newkey);
    }

    private static <K, V> void _concatenateListsContaining(Node<K, V> a, Node<K, V> b) {
        if (a == null || b == null) {
            return;
        }
        Node c = a.right;
        Node d = b.left;
        a.right = b;
        b.left = a;
        d.right = c;
        c.left = d;
    }

    private static <K, V> void _removeFromList(Node<K, V> a) {
        a.left.right = a.right;
        a.right.left = a.left;
        a.right = a;
        a.left = a.right;
    }

    private static int D(int n) {
        double Dn = Math.log(n) / log_phi;
        return (int)Math.floor(Dn);
    }

    public static void main(String[] args) {
        FibonacciHeap<Object, Object> h = new FibonacciHeap();
        if (!($assertionsDisabled || h.size() == 0 && h.isEmpty())) {
            throw new AssertionError();
        }
        h = new FibonacciHeap<Integer, Integer>(new AbstractCollection<Map.Entry<Integer, Integer>>(){
            int[] el = new int[]{-4, -1, -3, -2, -16, -9, -10, -14, -8, -7};

            @Override
            public int size() {
                return this.el.length;
            }

            @Override
            public Iterator<Map.Entry<Integer, Integer>> iterator() {
                return new UnmodifiableIterator<Map.Entry<Integer, Integer>>(this){
                    int i;
                    private final /* synthetic */ 3 this$0;
                    {
                        this.this$0 = var1_1;
                        this.i = 0;
                    }

                    public boolean hasNext() {
                        return this.i < this.this$0.el.length;
                    }

                    public Map.Entry<Integer, Integer> next() {
                        Integer io = new Integer(this.this$0.el[this.i++]);
                        return new PairMapEntry<Integer, Integer>(io, io);
                    }

                    public /* synthetic */ Object next() {
                        return this.next();
                    }
                };
            }

            @Override
            public /* synthetic */ boolean add(Object x0) {
                return super.add((Map.Entry)x0);
            }
        }, null);
        if (!$assertionsDisabled && (h.size() != 10 || h.isEmpty())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !((Integer)h.minimum().getKey()).equals(new Integer(-16))) {
            throw new AssertionError();
        }
        System.out.println(h);
        h.insert(new Integer(-15), new Integer(-15));
        if (!$assertionsDisabled && (h.size() != 11 || h.isEmpty())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !((Integer)h.minimum().getKey()).equals(new Integer(-16))) {
            throw new AssertionError();
        }
        System.out.println(h);
        System.out.println(h.size());
        if (!$assertionsDisabled && !((Integer)h.extractMinimum().getKey()).equals(new Integer(-16))) {
            throw new AssertionError();
        }
        System.out.println(h.size());
        System.out.println(h);
        if (!$assertionsDisabled && !((Integer)h.extractMinimum().getKey()).equals(new Integer(-15))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !((Integer)h.extractMinimum().getKey()).equals(new Integer(-14))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !((Integer)h.extractMinimum().getKey()).equals(new Integer(-10))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !((Integer)h.extractMinimum().getKey()).equals(new Integer(-9))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !((Integer)h.extractMinimum().getKey()).equals(new Integer(-8))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !((Integer)h.extractMinimum().getKey()).equals(new Integer(-7))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !((Integer)h.extractMinimum().getKey()).equals(new Integer(-4))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !((Integer)h.extractMinimum().getKey()).equals(new Integer(-3))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !((Integer)h.extractMinimum().getKey()).equals(new Integer(-2))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !((Integer)h.extractMinimum().getKey()).equals(new Integer(-1))) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || h.isEmpty() && h.size() == 0)) {
            throw new AssertionError();
        }
        h.clear();
        if (!($assertionsDisabled || h.isEmpty() && h.size() == 0)) {
            throw new AssertionError();
        }
        h = new FibonacciHeap();
        if (!($assertionsDisabled || h.isEmpty() && h.size() == 0)) {
            throw new AssertionError();
        }
        ArrayList<Map.Entry<Object, Object>> mel = new ArrayList<Map.Entry<Object, Object>>();
        mel.add(h.insert("C", "c1"));
        mel.add(h.insert("S", "s1"));
        mel.add(h.insert("A", "a"));
        mel.add(h.insert("S", "s2"));
        mel.add(h.insert("C", "c2"));
        mel.add(h.insert("O", "o"));
        mel.add(h.insert("T", "t1"));
        mel.add(h.insert("T", "t2"));
        mel.add(h.insert("Z", "z"));
        mel.add(h.insert("M", "m"));
        if (!$assertionsDisabled && !((String)h.extractMinimum().getValue()).equals("a")) {
            throw new AssertionError();
        }
        System.out.println(new StringBuffer().append("1: ").append(h).toString());
        h.decreaseKey((Map.Entry)mel.get(3), "B");
        System.out.println(new StringBuffer().append("2: ").append(h).toString());
        if (!$assertionsDisabled && !((String)h.extractMinimum().getValue()).equals("s2")) {
            throw new AssertionError();
        }
        h.delete((Map.Entry)mel.get(4));
        System.out.println(new StringBuffer().append("3: ").append(h).toString());
        if (!$assertionsDisabled && !((String)h.extractMinimum().getValue()).equals("c1")) {
            throw new AssertionError();
        }
        System.out.println(new StringBuffer().append("4: ").append(h).toString());
        h.updateKey((Map.Entry)mel.get(9), "P");
        if (!$assertionsDisabled && !((String)h.extractMinimum().getValue()).equals("o")) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !((String)h.extractMinimum().getValue()).equals("m")) {
            throw new AssertionError();
        }
        System.out.println(new StringBuffer().append("5: ").append(h).toString());
        System.out.println("PASSED.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static /* synthetic */ Node access$100(FibonacciHeap x0, Node x1) {
        return x0.successor(x1);
    }

    static {
        $assertionsDisabled = !(class$net$cscott$jutil$FibonacciHeap == null ? (class$net$cscott$jutil$FibonacciHeap = FibonacciHeap.class$("net.cscott.jutil.FibonacciHeap")) : class$net$cscott$jutil$FibonacciHeap).desiredAssertionStatus();
        phi = (1.0 + Math.sqrt(5.0)) / 2.0;
        log_phi = Math.log(phi);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Node<K, V> {
        Node<K, V> parent;
        Node<K, V> child;
        Entry<K, V> entry;
        Node<K, V> left;
        Node<K, V> right;
        int degree;
        boolean mark;
        static final /* synthetic */ boolean $assertionsDisabled;

        Node(Entry<K, V> e) {
            this.entry = e;
            this.entry.node = this;
            this.child = null;
            this.parent = null;
            this.degree = 0;
            this.left = this.right = this;
            this.mark = false;
        }

        void addChild(Node<K, V> c) {
            if (!($assertionsDisabled || c.left == c && c.right == c)) {
                throw new AssertionError();
            }
            if (this.child == null) {
                this.child = c;
            } else {
                FibonacciHeap._concatenateListsContaining(this.child, c);
            }
            c.parent = this;
            ++this.degree;
        }

        void removeChild(Node<K, V> c) {
            if (!$assertionsDisabled && c.parent != this) {
                throw new AssertionError();
            }
            if (this.child == c) {
                this.child = c.right;
            }
            FibonacciHeap._removeFromList(c);
            c.parent = null;
            --this.degree;
            if (this.degree == 0) {
                this.child = null;
            }
        }

        public String toString() {
            return new StringBuffer().append("<").append(this.entry).append(", d:").append(this.degree).append(", parent:").append(this._2s(this.parent)).append(", child:").append(this._2s(this.child)).append(", left:").append(this._2s(this.left)).append(", right:").append(this._2s(this.right)).append(", mark:").append(this.mark).append(">").toString();
        }

        private String _2s(Node<K, V> n) {
            return n == null ? "(nil)" : n.entry.toString();
        }

        static {
            $assertionsDisabled = !(class$net$cscott$jutil$FibonacciHeap == null ? (class$net$cscott$jutil$FibonacciHeap = FibonacciHeap.class$("net.cscott.jutil.FibonacciHeap")) : class$net$cscott$jutil$FibonacciHeap).desiredAssertionStatus();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Entry<K, V>
    extends PairMapEntry<K, V> {
        Node<K, V> node;

        Entry(K key, V value) {
            super(key, value);
        }

        K _setKey(K key) {
            return super.setKey(key);
        }
    }
}

