/*
 * Decompiled with CFR 0.152.
 */
package net.cscott.jutil;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.cscott.jutil.CollectionFactory;
import net.cscott.jutil.CollectionWrapper;
import net.cscott.jutil.LinearSet;
import net.cscott.jutil.ListFactory;
import net.cscott.jutil.MapFactory;
import net.cscott.jutil.MapSet;
import net.cscott.jutil.MultiMap;
import net.cscott.jutil.MultiMapFactory;
import net.cscott.jutil.MultiMapSet;
import net.cscott.jutil.SetFactory;
import net.cscott.jutil.SetWrapper;
import net.cscott.jutil.WorkSet;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Factories {
    public static final MapFactory hashMapFactory = Factories.hashMapFactory();
    public static final MapFactory linkedHashMapFactory = Factories.linkedHashMapFactory();
    public static final SetFactory hashSetFactory = Factories.hashSetFactory();
    public static final SetFactory linkedHashSetFactory = Factories.linkedHashSetFactory();
    public static final SetFactory workSetFactory = Factories.workSetFactory();
    public static final SetFactory linearSetFactory = Factories.linearSetFactory();
    public static final SetFactory treeSetFactory = Factories.treeSetFactory();
    public static final ListFactory linkedListFactory = Factories.linkedListFactory();
    public static final ListFactory arrayListFactory = Factories.arrayListFactory();
    static /* synthetic */ Class class$net$cscott$jutil$Factories;

    private Factories() {
    }

    public static final <K, V> MapFactory<K, V> hashMapFactory() {
        return new SerialMapFactory<K, V>(){

            @Override
            public HashMap<K, V> makeMap(Map<? extends K, ? extends V> map) {
                return new HashMap(map);
            }

            @Override
            public /* synthetic */ Map makeMap(Map x0) {
                return this.makeMap(x0);
            }
        };
    }

    public static final <K, V> MapFactory<K, V> linkedHashMapFactory() {
        return new SerialMapFactory<K, V>(){

            @Override
            public LinkedHashMap<K, V> makeMap(Map<? extends K, ? extends V> map) {
                return new LinkedHashMap(map);
            }

            @Override
            public /* synthetic */ Map makeMap(Map x0) {
                return this.makeMap(x0);
            }
        };
    }

    public static final <V> SetFactory<V> hashSetFactory() {
        return new SerialSetFactory<V>(){

            @Override
            public HashSet<V> makeSet(Collection<? extends V> c) {
                return new HashSet(c);
            }

            @Override
            public HashSet<V> makeSet(int i) {
                return new HashSet(i);
            }

            @Override
            public /* synthetic */ Set makeSet(Collection x0) {
                return this.makeSet(x0);
            }

            @Override
            public /* synthetic */ Set makeSet(int x0) {
                return this.makeSet(x0);
            }
        };
    }

    public static final <V> SetFactory<V> linkedHashSetFactory() {
        return new SerialSetFactory<V>(){

            @Override
            public LinkedHashSet<V> makeSet(Collection<? extends V> c) {
                return new LinkedHashSet(c);
            }

            @Override
            public LinkedHashSet<V> makeSet(int i) {
                return new LinkedHashSet(i);
            }

            @Override
            public /* synthetic */ Set makeSet(Collection x0) {
                return this.makeSet(x0);
            }

            @Override
            public /* synthetic */ Set makeSet(int x0) {
                return this.makeSet(x0);
            }
        };
    }

    public static final <V> SetFactory<V> workSetFactory() {
        return new SerialSetFactory<V>(){

            @Override
            public WorkSet<V> makeSet(Collection<? extends V> c) {
                return new WorkSet(c);
            }

            @Override
            public WorkSet<V> makeSet(int i) {
                return new WorkSet(i);
            }

            @Override
            public /* synthetic */ Set makeSet(Collection x0) {
                return this.makeSet(x0);
            }

            @Override
            public /* synthetic */ Set makeSet(int x0) {
                return this.makeSet(x0);
            }
        };
    }

    public static final <V> SetFactory<V> linearSetFactory() {
        return new SerialSetFactory<V>(){

            @Override
            public LinearSet<V> makeSet(Collection<? extends V> c) {
                LinearSet ls;
                if (c instanceof Set) {
                    ls = new LinearSet((Set)c);
                } else {
                    ls = new LinearSet(c.size());
                    ls.addAll(c);
                }
                return ls;
            }

            @Override
            public LinearSet<V> makeSet(int i) {
                return new LinearSet(i);
            }

            @Override
            public /* synthetic */ Set makeSet(Collection x0) {
                return this.makeSet(x0);
            }

            @Override
            public /* synthetic */ Set makeSet(int x0) {
                return this.makeSet(x0);
            }
        };
    }

    public static final <V> SetFactory<V> treeSetFactory() {
        return new SerialSetFactory<V>(){

            @Override
            public TreeSet<V> makeSet(Collection<? extends V> c) {
                return new TreeSet(c);
            }

            @Override
            public /* synthetic */ Set makeSet(Collection x0) {
                return this.makeSet(x0);
            }
        };
    }

    public static final <V> ListFactory<V> linkedListFactory() {
        return new SerialListFactory<V>(){

            @Override
            public LinkedList<V> makeList(Collection<? extends V> c) {
                return new LinkedList(c);
            }

            @Override
            public /* synthetic */ List makeList(Collection x0) {
                return this.makeList(x0);
            }
        };
    }

    public static final <V> ListFactory<V> arrayListFactory() {
        return new SerialListFactory<V>(){

            @Override
            public ArrayList<V> makeList(Collection<? extends V> c) {
                return new ArrayList(c);
            }

            @Override
            public ArrayList<V> makeList(int i) {
                return new ArrayList(i);
            }

            @Override
            public /* synthetic */ List makeList(Collection x0) {
                return this.makeList(x0);
            }

            @Override
            public /* synthetic */ List makeList(int x0) {
                return this.makeList(x0);
            }
        };
    }

    public static <K, V> SetFactory<Map.Entry<K, V>> mapSetFactory(final MapFactory<K, V> mf) {
        return new SerialSetFactory<Map.Entry<K, V>>(){

            @Override
            public Set<Map.Entry<K, V>> makeSet(Collection<? extends Map.Entry<K, V>> c) {
                Map m = mf.makeMap();
                for (Map.Entry me : c) {
                    m.put(me.getKey(), me.getValue());
                }
                Set s = m.entrySet();
                if (s instanceof MapSet && ((MapSet)s).asMap() == m) {
                    return s;
                }
                return new MapSetWrapper<K, V>(this, s, m){
                    private final /* synthetic */ Map val$m;
                    private final /* synthetic */ 10 this$0;
                    {
                        this.this$0 = var1_1;
                        this.val$m = var3_3;
                        super(x0);
                    }

                    public Map<K, V> asMap() {
                        return this.val$m;
                    }
                };
            }
        };
    }

    public static <K, V> SetFactory<Map.Entry<K, V>> multiMapSetFactory(final MultiMapFactory<K, V> mf) {
        return new SerialSetFactory<Map.Entry<K, V>>(){

            @Override
            public Set<Map.Entry<K, V>> makeSet(Collection<? extends Map.Entry<K, V>> c) {
                MultiMap m = mf.makeMultiMap();
                for (Map.Entry me : c) {
                    m.add(me.getKey(), me.getValue());
                }
                MultiMapSet s = m.entrySet();
                if (s instanceof MultiMapSet && s.asMultiMap() == m) {
                    return s;
                }
                return new MultiMapSetWrapper<K, V>(this, s, m){
                    private final /* synthetic */ MultiMap val$m;
                    private final /* synthetic */ 12 this$0;
                    {
                        this.this$0 = var1_1;
                        this.val$m = var3_3;
                        super(x0);
                    }

                    public MultiMap<K, V> asMap() {
                        return this.asMultiMap();
                    }

                    public MultiMap<K, V> asMultiMap() {
                        return this.val$m;
                    }

                    public /* synthetic */ Map asMap() {
                        return this.asMap();
                    }
                };
            }
        };
    }

    public static <V> CollectionFactory<V> synchronizedCollectionFactory(final CollectionFactory<V> cf) {
        return new SerialCollectionFactory<V>(){

            @Override
            public Collection<V> makeCollection(Collection<? extends V> c) {
                return Collections.synchronizedCollection(cf.makeCollection(c));
            }
        };
    }

    public static <V> SetFactory<V> synchronizedSetFactory(final SetFactory<V> sf) {
        return new SerialSetFactory<V>(){

            @Override
            public Set<V> makeSet(Collection<? extends V> c) {
                return Collections.synchronizedSet(sf.makeSet(c));
            }
        };
    }

    public static <V> ListFactory<V> synchronizedListFactory(final ListFactory<V> lf) {
        return new SerialListFactory<V>(){

            @Override
            public List<V> makeList(Collection<? extends V> c) {
                return Collections.synchronizedList(lf.makeList(c));
            }
        };
    }

    public static <K, V> MapFactory<K, V> synchronizedMapFactory(final MapFactory<K, V> mf) {
        return new SerialMapFactory<K, V>(){

            @Override
            public Map<K, V> makeMap(Map<? extends K, ? extends V> map) {
                return Collections.synchronizedMap(mf.makeMap(map));
            }
        };
    }

    public static <V> CollectionFactory<V> noNullCollectionFactory(final CollectionFactory<V> cf) {
        return new SerialCollectionFactory<V>(){
            static final /* synthetic */ boolean $assertionsDisabled;

            @Override
            public Collection<V> makeCollection(Collection<? extends V> c) {
                if (!$assertionsDisabled && !Factories.noNull(c)) {
                    throw new AssertionError();
                }
                Collection back = cf.makeCollection(c);
                return new CollectionWrapper<V>(this, back){
                    static final /* synthetic */ boolean $assertionsDisabled;
                    private final /* synthetic */ 18 this$0;
                    {
                        this.this$0 = var1_1;
                        super(x0);
                    }

                    public boolean add(V o) {
                        if (!$assertionsDisabled && o == null) {
                            throw new AssertionError();
                        }
                        return super.add(o);
                    }

                    public boolean addAll(Collection<? extends V> c2) {
                        if (!$assertionsDisabled && !Factories.access$400(c2)) {
                            throw new AssertionError();
                        }
                        return super.addAll(c2);
                    }

                    static {
                        $assertionsDisabled = !(class$net$cscott$jutil$Factories == null ? (class$net$cscott$jutil$Factories = Factories.class$("net.cscott.jutil.Factories")) : class$net$cscott$jutil$Factories).desiredAssertionStatus();
                    }
                };
            }

            static {
                $assertionsDisabled = !(class$net$cscott$jutil$Factories == null ? (class$net$cscott$jutil$Factories = Factories.class$("net.cscott.jutil.Factories")) : class$net$cscott$jutil$Factories).desiredAssertionStatus();
            }
        };
    }

    private static <V> boolean noNull(Collection<V> c) {
        Iterator<V> iter = c.iterator();
        while (iter.hasNext()) {
            if (iter.next() != null) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class SerialCollectionFactory<V>
    extends CollectionFactory<V>
    implements Serializable {
        private SerialCollectionFactory() {
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class SerialListFactory<V>
    extends ListFactory<V>
    implements Serializable {
        private SerialListFactory() {
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class SerialSetFactory<V>
    extends SetFactory<V>
    implements Serializable {
        private SerialSetFactory() {
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class SerialMapFactory<K, V>
    extends MapFactory<K, V>
    implements Serializable {
        private SerialMapFactory() {
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class MultiMapSetWrapper<K, V>
    extends SetWrapper<Map.Entry<K, V>>
    implements MultiMapSet<K, V> {
        MultiMapSetWrapper(Set<Map.Entry<K, V>> set) {
            super(set);
        }

        @Override
        public /* synthetic */ boolean add(Object x0) {
            return super.add((Map.Entry)x0);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class MapSetWrapper<K, V>
    extends SetWrapper<Map.Entry<K, V>>
    implements MapSet<K, V> {
        MapSetWrapper(Set<Map.Entry<K, V>> set) {
            super(set);
        }

        @Override
        public /* synthetic */ boolean add(Object x0) {
            return super.add((Map.Entry)x0);
        }
    }
}

