/*
 * Decompiled with CFR 0.152.
 */
package net.cscott.jutil;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.cscott.jutil.AbstractMapEntry;
import net.cscott.jutil.DisjointSet;
import net.cscott.jutil.GenericMultiMap;
import net.cscott.jutil.UnmodifiableIterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisjointSet<E> {
    private final Map<E, Node<E>> elmap = new HashMap<E, Node<E>>();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$net$cscott$jutil$DisjointSet;

    public void union(E o1, E o2) {
        Node<E> y;
        Node<E> x = this.elmap.get(o1);
        if (x == null) {
            x = this._make_set(o1);
        }
        if ((y = this.elmap.get(o2)) == null) {
            y = this._make_set(o2);
        }
        if (!$assertionsDisabled && x.equals(y)) {
            throw new AssertionError((Object)"Sets assumed to be disjoint");
        }
        this._union(x, y);
    }

    public E find(E o) {
        Node<E> x = this.elmap.get(o);
        if (x == null) {
            return o;
        }
        return this._find_set(x).element;
    }

    public boolean contains(Object o) {
        return this.elmap.containsKey(o);
    }

    private Node<E> _make_set(E o) {
        if (!$assertionsDisabled && this.elmap.containsKey(o)) {
            throw new AssertionError();
        }
        Node<E> x = new Node<E>(o);
        this.elmap.put(o, x);
        return x;
    }

    private Node<E> _find_set(Node<E> x) {
        if (x.parent != x) {
            x.parent = this._find_set(x.parent);
        }
        return x.parent;
    }

    private void _union(Node<E> x, Node<E> y) {
        this._link(this._find_set(x), this._find_set(y));
    }

    private void _link(Node<E> x, Node<E> y) {
        if (x.rank > y.rank) {
            y.parent = x;
        } else {
            x.parent = y;
            if (x.rank == y.rank) {
                ++y.rank;
            }
        }
    }

    public Map<E, E> asMap() {
        return new AbstractMap<E, E>(){

            @Override
            public boolean containsKey(Object key) {
                return DisjointSet.this.elmap.containsKey(key);
            }

            @Override
            public E get(Object key) {
                return DisjointSet.this.find(key);
            }

            @Override
            public Set<Map.Entry<E, E>> entrySet() {
                Set objects = DisjointSet.this.elmap.keySet();
                return new AbstractSet<Map.Entry<E, E>>(){
                    private final /* synthetic */ Set val$objects;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$objects = set;
                    }

                    public int size() {
                        return this.val$objects.size();
                    }

                    public Iterator<Map.Entry<E, E>> iterator() {
                        Iterator<E> objit = this.val$objects.iterator();
                        return new UnmodifiableIterator<Map.Entry<E, E>>(){
                            private final /* synthetic */ Iterator val$objit;
                            private final /* synthetic */ 2 this$2;
                            {
                                this.this$2 = var1_1;
                                this.val$objit = iterator;
                            }

                            public boolean hasNext() {
                                return this.val$objit.hasNext();
                            }

                            public Map.Entry<E, E> next() {
                                E key = this.val$objit.next();
                                return new AbstractMapEntry<E, E>(){
                                    private final /* synthetic */ Object val$key;
                                    private final /* synthetic */ 3 this$3;
                                    {
                                        this.this$3 = var1_1;
                                        this.val$key = object;
                                    }

                                    public E getKey() {
                                        return (E)this.val$key;
                                    }

                                    public E getValue() {
                                        return (E)1.access$300(2.access$200(3.access$100(this.this$3))).find(this.val$key);
                                    }
                                };
                            }

                            public /* synthetic */ Object next() {
                                return this.next();
                            }

                            static /* synthetic */ 2 access$100(3 x0) {
                                return x0.this$2;
                            }
                        };
                    }

                    public /* synthetic */ boolean add(Object x0) {
                        return super.add((Map.Entry)x0);
                    }

                    static /* synthetic */ 1 access$200(2 x0) {
                        return x0.this$1;
                    }
                };
            }

            static /* synthetic */ DisjointSet access$300(1 x0) {
                return x0.DisjointSet.this;
            }
        };
    }

    public String toString() {
        GenericMultiMap mm = new GenericMultiMap();
        for (Node<E> n : this.elmap.values()) {
            Node<E> r;
            if (n == (r = this._find_set(n))) continue;
            mm.add(r.element, n.element);
        }
        return ((Object)mm).toString();
    }

    public static void main(String[] args) {
        DisjointSet<String> ds = new DisjointSet<String>();
        String a = "a";
        String b = "b";
        String c = "c";
        String d = "d";
        String e = "e";
        String f = "f";
        String g = "g";
        String h = "h";
        if (!$assertionsDisabled && (ds.contains(a) || ds.contains(b) || ds.contains(c))) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || ds.find(a) == a && ds.find(b) == b && ds.find(c) == c)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && (ds.contains(a) || ds.contains(b) || ds.contains(c))) {
            throw new AssertionError();
        }
        ds.union(e, c);
        ds.union(b, h);
        ds.union(h, c);
        if (!($assertionsDisabled || ds.find(e) == ds.find(c) && ds.find(h) == ds.find(e))) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || ds.find(b) == ds.find(c) && ds.find(b) != ds.find(a))) {
            throw new AssertionError();
        }
        ds.union(d, f);
        ds.union(g, d);
        if (!($assertionsDisabled || ds.find(d) == ds.find(f) && ds.find(f) == ds.find(g))) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || ds.find(d) != ds.find(c) && ds.find(d) != ds.find(a))) {
            throw new AssertionError();
        }
        ds.union(c, f);
        if (!$assertionsDisabled && ds.find(e) != ds.find(f)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && ds.find(a) != a) {
            throw new AssertionError();
        }
        System.err.println("PASSED.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$net$cscott$jutil$DisjointSet == null ? (class$net$cscott$jutil$DisjointSet = DisjointSet.class$("net.cscott.jutil.DisjointSet")) : class$net$cscott$jutil$DisjointSet).desiredAssertionStatus();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node<E> {
        Node<E> parent = this;
        final E element;
        int rank;

        Node(E element) {
            this.element = element;
            this.rank = 0;
        }
    }
}

