/*
 * Decompiled with CFR 0.152.
 */
package net.cscott.jutil;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import net.cscott.jutil.AbstractMapEntry;
import net.cscott.jutil.MapSet;
import net.cscott.jutil.MultiMap;
import net.cscott.jutil.MultiMapSet;
import net.cscott.jutil.UnmodifiableIterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Default {
    public static final Comparator comparator = Default.comparator();
    public static final Iterator nullIterator = Default.nullIterator();
    public static final SortedSet EMPTY_SET = Default.EMPTY_SET();
    public static final SortedMap EMPTY_MAP = Default.EMPTY_MAP();
    public static final MultiMap EMPTY_MULTIMAP = Default.EMPTY_MULTIMAP();

    public static final <T> Comparator<T> comparator() {
        return new SerializableComparator<T>(){

            @Override
            public int compare(T t1, T t2) {
                if (t1 == null && t2 == null) {
                    return 0;
                }
                if (t1 == null) {
                    return -1;
                }
                if (t2 == null) {
                    return 1;
                }
                return ((Comparable)t1).compareTo(t2);
            }
        };
    }

    public static final <E> Iterator<E> nullIterator() {
        return new UnmodifiableIterator<E>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public E next() {
                throw new NoSuchElementException();
            }
        };
    }

    public static final <E> Iterator<E> singletonIterator(E o) {
        return Collections.singletonList(o).iterator();
    }

    public static final <E> Iterator<E> unmodifiableIterator(final Iterator<E> i) {
        return new UnmodifiableIterator<E>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public E next() {
                return i.next();
            }
        };
    }

    public static final <E> SortedSet<E> EMPTY_SET() {
        return new EmptySortedSet();
    }

    public static final <E> List<E> EMPTY_LIST() {
        return new SerializableAbstractList<E>(){

            @Override
            public int size() {
                return 0;
            }

            @Override
            public E get(int index) {
                throw new IndexOutOfBoundsException();
            }
        };
    }

    public static final <K, V> SortedMap<K, V> EMPTY_MAP() {
        return new EmptySortedMap();
    }

    public static final <K, V> MultiMap<K, V> EMPTY_MULTIMAP() {
        return new EmptyMultiMap();
    }

    public static <A> Collection<A> unmodifiableCollection(final Collection<? extends A> cc) {
        return new AbstractCollection<A>(){

            @Override
            public boolean containsAll(Collection<?> c) {
                return cc.containsAll(c);
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                return cc.removeAll(c);
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                return cc.retainAll(c);
            }

            @Override
            public boolean contains(Object o) {
                return cc.contains(o);
            }

            @Override
            public boolean isEmpty() {
                return cc.isEmpty();
            }

            @Override
            public Iterator<A> iterator() {
                Iterator it = cc.iterator();
                return new UnmodifiableIterator<A>(){
                    private final /* synthetic */ Iterator val$it;
                    private final /* synthetic */ 5 this$0;
                    {
                        this.this$0 = var1_1;
                        this.val$it = iterator;
                    }

                    public boolean hasNext() {
                        return this.val$it.hasNext();
                    }

                    public A next() {
                        return (A)this.val$it.next();
                    }
                };
            }

            @Override
            public int size() {
                return cc.size();
            }
        };
    }

    public static <A, B> PairList<A, B> pair(A left, B right) {
        return new PairList<A, B>(left, right);
    }

    public static <K, V> Map.Entry<K, V> entry(final K key, final V value) {
        return new AbstractMapEntry<K, V>(){

            @Override
            public K getKey() {
                return key;
            }

            @Override
            public V getValue() {
                return value;
            }
        };
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class SerializableAbstractList<E>
    extends AbstractList<E>
    implements Serializable {
        private SerializableAbstractList() {
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface SerializableComparator<A>
    extends Comparator<A>,
    Serializable {
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PairList<A, B>
    extends AbstractList
    implements Serializable {
        private A left;
        private B right;

        public PairList(A left, B right) {
            this.left = left;
            this.right = right;
        }

        public A left() {
            return this.left;
        }

        public B right() {
            return this.right;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public Object get(int index) {
            switch (index) {
                case 0: {
                    return this.left;
                }
                case 1: {
                    return this.right;
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public Object set(int index, Object element) {
            switch (index) {
                case 0: {
                    A prev = this.left;
                    this.left = element;
                    return prev;
                }
                case 1: {
                    B prev = this.right;
                    this.right = element;
                    return prev;
                }
            }
            throw new IndexOutOfBoundsException();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyMultiMap<K, V>
    extends EmptyMap<K, V>
    implements MultiMap<K, V> {
        private EmptyMultiMap() {
        }

        @Override
        public MultiMapSet<K, V> entrySet() {
            return new EmptyMultiMapSet(this);
        }

        @Override
        public boolean remove(Object key, Object value) {
            return false;
        }

        @Override
        public boolean add(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(K key, Collection<? extends V> values) {
            if (values.size() == 0) {
                return false;
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(MultiMap<? extends K, ? extends V> mm) {
            if (mm.size() == 0) {
                return false;
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(K key, Collection<?> values) {
            return false;
        }

        @Override
        public boolean removeAll(K key, Collection<?> values) {
            return false;
        }

        @Override
        public SortedSet<V> getValues(K key) {
            return Default.EMPTY_SET();
        }

        @Override
        public boolean contains(Object key, Object value) {
            return false;
        }

        @Override
        public /* synthetic */ MapSet entrySet() {
            return this.entrySet();
        }

        @Override
        public /* synthetic */ Set entrySet() {
            return this.entrySet();
        }

        @Override
        public /* synthetic */ Collection getValues(Object x0) {
            return this.getValues(x0);
        }

        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class EmptyMultiMapSet<K, V>
        extends EmptySortedSet<Map.Entry<K, V>>
        implements MultiMapSet<K, V> {
            MultiMap<K, V> parent;

            EmptyMultiMapSet(MultiMap<K, V> parent) {
                this.parent = parent;
            }

            @Override
            public MultiMap<K, V> asMap() {
                return this.parent;
            }

            @Override
            public MultiMap<K, V> asMultiMap() {
                return this.parent;
            }

            @Override
            public /* synthetic */ Object last() {
                return super.last();
            }

            @Override
            public /* synthetic */ Object first() {
                return super.first();
            }

            @Override
            public /* synthetic */ SortedSet tailSet(Object x0) {
                return super.tailSet((Map.Entry)x0);
            }

            @Override
            public /* synthetic */ SortedSet headSet(Object x0) {
                return super.headSet((Map.Entry)x0);
            }

            @Override
            public /* synthetic */ SortedSet subSet(Object x0, Object x1) {
                return super.subSet((Map.Entry)x0, (Map.Entry)x1);
            }

            @Override
            public /* synthetic */ boolean add(Object x0) {
                return super.add((Map.Entry)x0);
            }

            @Override
            public /* synthetic */ Map asMap() {
                return this.asMap();
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptySortedMap<K, V>
    extends EmptyMap<K, V>
    implements SortedMap<K, V> {
        private EmptySortedMap() {
        }

        @Override
        public Comparator<? super K> comparator() {
            return null;
        }

        @Override
        public K firstKey() {
            throw new NoSuchElementException();
        }

        @Override
        public K lastKey() {
            throw new NoSuchElementException();
        }

        @Override
        public SortedMap<K, V> headMap(K toKey) {
            return this;
        }

        @Override
        public SortedMap<K, V> tailMap(K fromKey) {
            return this;
        }

        @Override
        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            return this;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyMap<K, V>
    implements Map<K, V>,
    Serializable {
        private EmptyMap() {
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        public MapSet<K, V> entrySet() {
            return new EmptyMapSet(this);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map)) {
                return false;
            }
            return ((Map)o).size() == 0;
        }

        @Override
        public V get(Object key) {
            return null;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Set<K> keySet() {
            return Default.EMPTY_SET();
        }

        @Override
        public V put(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> t) {
            if (t.size() == 0) {
                return;
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(Object key) {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Collection<V> values() {
            return Default.EMPTY_SET();
        }

        public String toString() {
            return "{}";
        }

        @Override
        public /* synthetic */ Set entrySet() {
            return this.entrySet();
        }

        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class EmptyMapSet<K, V>
        extends EmptySortedSet<Map.Entry<K, V>>
        implements MapSet<K, V> {
            Map<K, V> parent;

            EmptyMapSet(Map<K, V> parent) {
                this.parent = parent;
            }

            @Override
            public Map<K, V> asMap() {
                return this.parent;
            }

            @Override
            public /* synthetic */ Object last() {
                return super.last();
            }

            @Override
            public /* synthetic */ Object first() {
                return super.first();
            }

            @Override
            public /* synthetic */ SortedSet tailSet(Object x0) {
                return super.tailSet((Map.Entry)x0);
            }

            @Override
            public /* synthetic */ SortedSet headSet(Object x0) {
                return super.headSet((Map.Entry)x0);
            }

            @Override
            public /* synthetic */ SortedSet subSet(Object x0, Object x1) {
                return super.subSet((Map.Entry)x0, (Map.Entry)x1);
            }

            @Override
            public /* synthetic */ boolean add(Object x0) {
                return super.add((Map.Entry)x0);
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptySortedSet<E>
    extends EmptySet<E>
    implements SortedSet<E> {
        private EmptySortedSet() {
        }

        @Override
        public Comparator<E> comparator() {
            return null;
        }

        @Override
        public SortedSet<E> subSet(E fromEl, E toEl) {
            return this;
        }

        @Override
        public SortedSet<E> headSet(E toEl) {
            return this;
        }

        @Override
        public SortedSet<E> tailSet(E fromEl) {
            return this;
        }

        @Override
        public E first() {
            throw new NoSuchElementException();
        }

        @Override
        public E last() {
            throw new NoSuchElementException();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptySet<E>
    implements Set<E>,
    Serializable {
        private EmptySet() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(Object e) {
            return false;
        }

        @Override
        public Iterator<E> iterator() {
            return Default.nullIterator();
        }

        @Override
        public Object[] toArray() {
            return new Object[0];
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }

        @Override
        public boolean add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object e) {
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return c.isEmpty();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            if (c.isEmpty()) {
                return false;
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return false;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return false;
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Set)) {
                return false;
            }
            return ((Set)o).size() == 0;
        }

        @Override
        public int hashCode() {
            return 0;
        }
    }
}

