/*
 * Decompiled with CFR 0.152.
 */
package net.cscott.jutil;

import java.io.Serializable;
import net.cscott.jutil.Util;

public final class BitString
implements Cloneable,
Serializable {
    private static final int BITS_PER_UNIT = 5;
    private static final int MASK = 31;
    private int[] bits;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static int subscript(int bitIndex) {
        return bitIndex >> 5;
    }

    private static int bitIndex(int subscript) {
        return (subscript << 5) + 31;
    }

    public BitString(int nbits) {
        this.bits = new int[BitString.subscript(nbits + 31)];
    }

    public int firstSet() {
        return this.firstSet(-1);
    }

    public int firstSet(int where) {
        where = where < -1 ? 0 : where + 1;
        int mask = -1 << (where & 0x1F);
        for (int i = BitString.subscript(where); i < this.bits.length; ++i) {
            int unit = this.bits[i] & mask;
            if (unit != 0) {
                return (i << 5) + (Util.ffs(unit) - 1);
            }
            mask = -1;
        }
        return -1;
    }

    public int lastSet(int where) {
        if (--where < 0) {
            return -1;
        }
        int start = this.bits.length - 1;
        int mask = -1;
        if (BitString.subscript(where) < this.bits.length) {
            start = BitString.subscript(where);
            mask = -1 >>> 31 - (where & mask);
        }
        for (int i = start; i >= 0; --i) {
            int unit = this.bits[i] & mask;
            if (unit != 0) {
                return (i << 5) + (Util.fls(unit) - 1);
            }
            mask = -1;
        }
        return -1;
    }

    public int lastSet() {
        return this.lastSet(this.size());
    }

    public void setAll() {
        int i = this.bits.length;
        while (i-- > 0) {
            this.bits[i] = -1;
        }
    }

    public void setUpTo(int bit) {
        int where;
        int n = where = BitString.subscript(bit);
        this.bits[n] = this.bits[n] | (1 << (bit + 1 & 0x1F)) - 1;
        while (where-- > 0) {
            this.bits[where] = -1;
        }
    }

    public void set(int bit) {
        int n = BitString.subscript(bit);
        this.bits[n] = this.bits[n] | 1 << (bit & 0x1F);
    }

    public void clearAll() {
        int i = this.bits.length;
        while (i-- > 0) {
            this.bits[i] = 0;
        }
    }

    public void clearUpTo(int bit) {
        int where;
        int n = where = BitString.subscript(bit);
        this.bits[n] = this.bits[n] & ~((1 << (bit + 1 & 0x1F)) - 1);
        while (where-- > 0) {
            this.bits[where] = 0;
        }
    }

    public void clear(int bit) {
        int n = BitString.subscript(bit);
        this.bits[n] = this.bits[n] & ~(1 << (bit & 0x1F));
    }

    public boolean get(int bit) {
        int n = BitString.subscript(bit);
        return (this.bits[n] & 1 << (bit & 0x1F)) != 0;
    }

    public boolean and(BitString set) {
        if (this == set) {
            return false;
        }
        int n = this.bits.length;
        boolean changed = false;
        int i = n;
        while (i-- > 0) {
            int old = this.bits[i];
            int n2 = i;
            this.bits[n2] = this.bits[n2] & set.bits[i];
            changed |= old != this.bits[i];
        }
        return changed;
    }

    public boolean or(BitString set) {
        if (this == set) {
            return false;
        }
        int setLength = set.bits.length;
        boolean changed = false;
        int i = setLength;
        while (i-- > 0) {
            int old = this.bits[i];
            int n = i;
            this.bits[n] = this.bits[n] | set.bits[i];
            changed |= old != this.bits[i];
        }
        return changed;
    }

    public boolean or_upTo(BitString set, int bit) {
        boolean result;
        if (this == set) {
            return false;
        }
        int where = BitString.subscript(bit);
        int old = this.bits[where];
        int n = where;
        this.bits[n] = this.bits[n] | set.bits[where] & (1 << (bit + 1 & 0x1F)) - 1;
        boolean bl = result = this.bits[where] != old;
        while (where-- > 0) {
            old = this.bits[where];
            int n2 = where;
            this.bits[n2] = this.bits[n2] | set.bits[where];
            result |= this.bits[where] != old;
        }
        return result;
    }

    public boolean xor(BitString set) {
        int setLength = set.bits.length;
        boolean changed = false;
        int i = setLength;
        while (i-- > 0) {
            int old = this.bits[i];
            int n = i;
            this.bits[n] = this.bits[n] ^ set.bits[i];
            changed |= old != this.bits[i];
        }
        return changed;
    }

    public boolean intersectionEmpty(BitString other) {
        int n;
        int i = n = this.bits.length;
        while (i-- > 0) {
            if ((this.bits[i] & other.bits[i]) == 0) continue;
            return false;
        }
        return true;
    }

    public void copyBits(BitString set) {
        int setLength;
        int i = setLength = set.bits.length;
        while (i-- > 0) {
            this.bits[i] = set.bits[i];
        }
    }

    public int hashCode() {
        int h = 1234 * this.bits.length;
        int i = this.bits.length;
        while (--i >= 0) {
            h ^= this.bits[i] * (i + 1);
        }
        return h;
    }

    public int length() {
        return this.lastSet() + 1;
    }

    public int size() {
        return this.bits.length << 5;
    }

    public boolean equals(Object obj) {
        BitString set;
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        try {
            set = (BitString)obj;
        }
        catch (ClassCastException e) {
            return false;
        }
        if (this.length() != set.length()) {
            return false;
        }
        for (int n = this.bits.length - 1; n >= 0 && this.bits[n] == 0; --n) {
        }
        for (int i = n; i >= 0; --i) {
            if (this.bits[i] == set.bits[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isZero() {
        int setLength;
        int i = setLength = this.bits.length;
        while (i-- > 0) {
            if (this.bits[i] == 0) continue;
            return false;
        }
        return true;
    }

    public int numberOfOnes() {
        int setLength = this.bits.length;
        int number = 0;
        int i = setLength;
        while (i-- > 0) {
            number += BitString.howManyOneBits(this.bits[i]);
        }
        return number;
    }

    public int numberOfOnes(int where) {
        int setLength = BitString.subscript(where);
        int number = 0;
        int i = setLength;
        while (i-- > 0) {
            number += BitString.howManyOneBits(this.bits[i]);
        }
        return number += BitString.howManyOneBits(this.bits[setLength] & (1 << (where + 1 & 0x1F)) - 1);
    }

    private static int howManyOneBits(int x) {
        return Util.popcount(x);
    }

    public BitString clone() {
        BitString result = null;
        try {
            result = (BitString)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        result.bits = new int[this.bits.length];
        System.arraycopy(this.bits, 0, result.bits, 0, result.bits.length);
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        boolean needSeparator = false;
        buffer.append('{');
        int limit = this.size();
        for (int i = 0; i < limit; ++i) {
            if (!this.get(i)) continue;
            if (needSeparator) {
                buffer.append(", ");
            } else {
                needSeparator = true;
            }
            buffer.append(i);
        }
        buffer.append('}');
        return buffer.toString();
    }

    public static void main(String[] argv) {
        BitString bs = new BitString(100);
        if (!($assertionsDisabled || bs.length() == 0 && bs.firstSet() == -1 && bs.lastSet() == -1)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || bs.firstSet(100) == -1 && bs.firstSet(-100) == -1)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || bs.lastSet(100) == -1 && bs.lastSet(-100) == -1)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && bs.size() < bs.length()) {
            throw new AssertionError();
        }
        bs.set(52);
        bs.set(53);
        bs.set(76);
        bs.set(77);
        if (!($assertionsDisabled || bs.get(52) && bs.get(53) && bs.get(76) && bs.get(77))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && (bs.get(51) || bs.get(54) || bs.get(75) || bs.get(78))) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || bs.length() == 78 && bs.size() >= bs.length())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && bs.firstSet() != bs.firstSet(-100)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || bs.firstSet(-1) == 52 && bs.firstSet(52) == 53)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || bs.firstSet(53) == 76 && bs.firstSet(76) == 77)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || bs.firstSet(77) == -1 && bs.firstSet(1000) == -1)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && bs.lastSet() != bs.lastSet(99)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || bs.lastSet(99) == 77 && bs.lastSet(77) == 76)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || bs.lastSet(76) == 53 && bs.lastSet(53) == 52)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || bs.lastSet(52) == -1 && bs.lastSet(-100) == -1)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !bs.toString().equals("{52, 53, 76, 77}")) {
            throw new AssertionError();
        }
        System.out.println("TESTS PASSED");
    }

    public /* synthetic */ Object clone() throws CloneNotSupportedException {
        return this.clone();
    }

    static {
        $assertionsDisabled = !BitString.class.desiredAssertionStatus();
    }
}

