/*
 * Decompiled with CFR 0.152.
 */
package net.cscott.jutil;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import net.cscott.jutil.BitSetFactory;
import net.cscott.jutil.BitString;
import net.cscott.jutil.FilterIterator;
import net.cscott.jutil.Indexer;
import net.cscott.jutil.SetFactory;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitSetFactory<V>
extends SetFactory<V> {
    private Indexer<V> indexer;
    private int bitStringSize;
    private Set<V> universe;
    private BitStringSet<V> bitUniverse = null;

    public BitSetFactory(Set<V> universe, Indexer<V> indexer) {
        Iterator<V> vals = universe.iterator();
        this.indexer = indexer;
        this.universe = universe;
        int max = 0;
        while (vals.hasNext()) {
            int i = indexer.getID(vals.next());
            if (i <= max) continue;
            max = i;
        }
        this.bitStringSize = max + 1;
    }

    public BitSetFactory(Set<V> universe) {
        final HashMap<V, Integer> obj2int = new HashMap<V, Integer>();
        final ArrayList<V> int2obj = new ArrayList<V>();
        Iterator<V> iter = universe.iterator();
        this.universe = universe;
        int i = 0;
        while (iter.hasNext()) {
            V o = iter.next();
            obj2int.put(o, new Integer(i));
            int2obj.add(i, o);
            ++i;
        }
        this.bitStringSize = i + 1;
        this.indexer = new Indexer<V>(){

            @Override
            public int getID(V o) {
                return (Integer)obj2int.get(o);
            }

            @Override
            public V getByID(int id) {
                return int2obj.get(id);
            }

            @Override
            public boolean implementsReverseMapping() {
                return true;
            }
        };
    }

    @Override
    public BitStringSet<V> makeSet(Collection<? extends V> c) {
        BitStringSet<? extends V> bss = new BitStringSet<V>(this.bitStringSize, this);
        bss.addAll(c);
        return bss;
    }

    public Set<V> makeFullSet() {
        if (this.bitUniverse == null) {
            this.bitUniverse = this.makeSet(this.universe);
        }
        return this.bitUniverse.clone();
    }

    private static final int elemHashCode(Object obj) {
        return obj == null ? 0 : obj.hashCode();
    }

    @Override
    public /* synthetic */ Set makeSet(Collection x0) {
        return this.makeSet(x0);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BitStringSet<V>
    extends AbstractSet<V>
    implements Cloneable {
        final BitString bs;
        int hashCode;
        boolean hashCodeValid;
        final BitSetFactory<V> fact;

        BitStringSet(int size, BitSetFactory<V> fact) {
            this.bs = new BitString(size);
            this.fact = fact;
            this.hashCode = 0;
            this.hashCodeValid = true;
        }

        private BitStringSet(BitStringSet<V> s) {
            this.bs = s.bs.clone();
            this.hashCode = s.hashCode;
            this.hashCodeValid = s.hashCodeValid;
            this.fact = s.fact;
        }

        @Override
        public boolean add(V o) {
            if (!((BitSetFactory)this.fact).universe.contains(o)) {
                throw new IllegalArgumentException(new StringBuffer().append("Attempted to add an object: ").append(o).append("that was not part of the ").append("original universe of values.").toString());
            }
            int ind = ((BitSetFactory)this.fact).indexer.getID(o);
            boolean alreadySet = this.bs.get(ind);
            if (alreadySet) {
                return false;
            }
            this.bs.set(ind);
            if (this.hashCodeValid) {
                this.hashCode += BitSetFactory.elemHashCode(o);
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends V> c) {
            if (c instanceof BitStringSet && ((BitStringSet)c).fact == this.fact) {
                BitStringSet bss = (BitStringSet)c;
                this.hashCodeValid = false;
                return this.bs.or(bss.bs);
            }
            return super.addAll(c);
        }

        @Override
        public void clear() {
            this.bs.clearAll();
            this.hashCode = 0;
            this.hashCodeValid = true;
        }

        @Override
        public boolean contains(Object o) {
            if (((BitSetFactory)this.fact).universe.contains(o)) {
                int i = ((BitSetFactory)this.fact).indexer.getID(o);
                return this.bs.get(i);
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            if (c instanceof BitStringSet && ((BitStringSet)c).fact == this.fact) {
                BitString notBS = this.bs.clone();
                notBS.setAll();
                notBS.xor(this.bs);
                BitStringSet bss = (BitStringSet)c;
                return bss.bs.intersectionEmpty(notBS);
            }
            return super.containsAll(c);
        }

        public BitStringSet<V> clone() {
            return new BitStringSet<V>(this);
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (o instanceof BitStringSet) {
                BitStringSet bss = (BitStringSet)o;
                if (this.fact == bss.fact) {
                    return this.bs.equals(bss.bs);
                }
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            if (!this.hashCodeValid) {
                this.hashCode = super.hashCode();
                this.hashCodeValid = true;
            }
            return this.hashCode;
        }

        @Override
        public boolean isEmpty() {
            return this.bs.isZero();
        }

        @Override
        public Iterator<V> iterator() {
            return ((BitSetFactory)this.fact).indexer.implementsReverseMapping() ? new Iterator<V>(this){
                int lastindex;
                private final /* synthetic */ BitStringSet this$0;
                {
                    this.this$0 = bitStringSet;
                    this.lastindex = -1;
                }

                public boolean hasNext() {
                    return this.this$0.bs.firstSet(this.lastindex) != -1;
                }

                public V next() {
                    this.lastindex = this.this$0.bs.firstSet(this.lastindex);
                    if (this.lastindex < 0) {
                        throw new NoSuchElementException();
                    }
                    return (V)BitSetFactory.access$100(this.this$0.fact).getByID(this.lastindex);
                }

                public void remove() {
                    if (this.lastindex < 0 || !this.this$0.bs.get(this.lastindex)) {
                        throw new IllegalStateException();
                    }
                    this.this$0.bs.clear(this.lastindex);
                    if (this.this$0.hashCodeValid) {
                        this.this$0.hashCode -= BitSetFactory.access$200(BitSetFactory.access$100(this.this$0.fact).getByID(this.lastindex));
                    }
                }
            } : new Iterator<V>(this){
                Iterator<V> internIter;
                V last;
                private final /* synthetic */ BitStringSet this$0;
                {
                    this.this$0 = bitStringSet;
                    this.internIter = new FilterIterator<E, V>(BitSetFactory.access$000(this.this$0.fact).iterator(), new FilterIterator.Filter<V, V>(this){
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public boolean isElement(V o) {
                            return 3.access$300(this.this$1).bs.get(BitSetFactory.access$100(3.access$300(this.this$1).fact).getID(o));
                        }
                    });
                    this.last = null;
                }

                public V next() {
                    this.last = this.internIter.next();
                    return this.last;
                }

                public boolean hasNext() {
                    return this.internIter.hasNext();
                }

                public void remove() {
                    this.this$0.bs.clear(BitSetFactory.access$100(this.this$0.fact).getID(this.last));
                    if (this.this$0.hashCodeValid) {
                        this.this$0.hashCode -= BitSetFactory.access$200(this.last);
                    }
                }

                static /* synthetic */ BitStringSet access$300(3 x0) {
                    return x0.this$0;
                }
            };
        }

        @Override
        public boolean remove(Object o) {
            if (!((BitSetFactory)this.fact).universe.contains(o)) {
                return false;
            }
            int i = ((BitSetFactory)this.fact).indexer.getID(o);
            boolean alreadySet = this.bs.get(i);
            if (alreadySet) {
                this.bs.clear(i);
                if (this.hashCodeValid) {
                    this.hashCode -= BitSetFactory.elemHashCode(o);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            if (c instanceof BitStringSet && ((BitStringSet)c).fact == this.fact) {
                this.hashCodeValid = false;
                BitStringSet bss = (BitStringSet)c;
                BitString notBSS = bss.bs.clone();
                notBSS.setAll();
                notBSS.xor(bss.bs);
                return this.bs.and(notBSS);
            }
            if (c.size() < this.size()) {
                boolean changed = false;
                Iterator<?> i = c.iterator();
                while (i.hasNext()) {
                    changed |= this.remove(i.next());
                }
                return changed;
            }
            return super.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            if (c instanceof BitStringSet && ((BitStringSet)c).fact == this.fact) {
                this.hashCodeValid = false;
                BitStringSet bss = (BitStringSet)c;
                return this.bs.and(bss.bs);
            }
            return super.retainAll(c);
        }

        @Override
        public int size() {
            return this.bs.numberOfOnes();
        }

        public /* synthetic */ Object clone() throws CloneNotSupportedException {
            return this.clone();
        }
    }
}

