/*
 * Decompiled with CFR 0.152.
 */
package net.cscott.jutil;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import net.cscott.jutil.AbstractHeap;
import net.cscott.jutil.Heap;
import net.cscott.jutil.PairMapEntry;
import net.cscott.jutil.UnmodifiableIterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinomialHeap<K, V>
extends AbstractHeap<K, V>
implements Cloneable {
    private static final boolean debug = false;
    Node<K, V> head = null;
    final Comparator<Map.Entry<K, V>> c = this.entryComparator();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$net$cscott$jutil$BinomialHeap;

    public BinomialHeap() {
        this(Collections.EMPTY_SET, null);
    }

    public BinomialHeap(Comparator<K> c) {
        this(Collections.EMPTY_SET, c);
    }

    public BinomialHeap(Heap<K, ? extends V> h) {
        this(h.entries(), h.comparator());
    }

    public BinomialHeap(Collection<? extends Map.Entry<? extends K, ? extends V>> collection, Comparator<K> comparator) {
        super(comparator);
        this.union(collection);
    }

    @Override
    public Map.Entry<K, V> minimum() {
        Node<K, V> y = null;
        Node<K, V> x = this.head;
        while (x != null) {
            if (y == null || this.c.compare(x.entry, y.entry) < 0) {
                y = x;
            }
            x = x.sibling;
        }
        if (y == null) {
            throw new NoSuchElementException();
        }
        return y.entry;
    }

    private void _link(Node<K, V> y, Node<K, V> z) {
        y.parent = z;
        y.sibling = z.child;
        z.child = y;
        ++z.degree;
    }

    private Node<K, V> _merge(Node<K, V> h1, Node<K, V> h2) {
        if (h1 == null) {
            return h2;
        }
        if (h2 == null) {
            return h1;
        }
        if (h1.degree < h2.degree) {
            h1.sibling = this._merge(h1.sibling, h2);
            return h1;
        }
        h2.sibling = this._merge(h1, h2.sibling);
        return h2;
    }

    @Override
    public void union(Heap<? extends K, ? extends V> h) {
        if (h instanceof BinomialHeap && ((Object)this.entryComparator()).equals(((BinomialHeap)h).entryComparator())) {
            this.union((BinomialHeap)h);
        } else {
            this.union(h.entries());
            h.clear();
        }
    }

    private void union(Collection<? extends Map.Entry<? extends K, ? extends V>> coll) {
        ArrayList hal = new ArrayList(coll.size());
        for (Map.Entry<K, V> e : coll) {
            BinomialHeap<K, V> bh = new BinomialHeap<K, V>(this.comparator());
            bh.insert(e.getKey(), e.getValue());
            hal.add(bh);
        }
        while (hal.size() > 1) {
            for (int i = 0; i < hal.size() - 1; ++i) {
                ((BinomialHeap)hal.get(i)).union((BinomialHeap)hal.remove(hal.size() - 1));
            }
        }
        if (hal.size() > 0) {
            this.union((BinomialHeap)hal.get(0));
        }
    }

    @Override
    public void union(BinomialHeap<K, V> m) {
        if (!$assertionsDisabled && !((Object)m.c).equals(this.c)) {
            throw new AssertionError();
        }
        this.union(m.head);
        m.head = null;
    }

    @Override
    void union(Node<K, V> n) {
        this.head = this._merge(this.head, n);
        if (this.head == null) {
            return;
        }
        Node<K, V> prevx = null;
        Node<K, V> x = this.head;
        Node nextx = x.sibling;
        while (nextx != null) {
            if (x.degree != nextx.degree || nextx.sibling != null && nextx.sibling.degree == x.degree) {
                prevx = x;
                x = nextx;
            } else if (this.c.compare(x.entry, nextx.entry) <= 0) {
                x.sibling = nextx.sibling;
                this._link(nextx, x);
            } else {
                if (prevx == null) {
                    this.head = nextx;
                } else {
                    prevx.sibling = nextx;
                }
                this._link(x, nextx);
                x = nextx;
            }
            nextx = x.sibling;
        }
    }

    @Override
    public Map.Entry<K, V> insert(K key, V value) {
        Entry<K, V> e = new Entry<K, V>(key, value);
        this.insert(e);
        return e;
    }

    @Override
    protected void insert(Map.Entry<K, V> me) {
        Entry e = (Entry)me;
        Node x = new Node(e);
        this.union(x);
    }

    @Override
    public Map.Entry<K, V> extractMinimum() {
        Node x = ((Entry)this.minimum()).node;
        this._removeRoot(x);
        return x.entry;
    }

    private void _removeRoot(Node<K, V> x) {
        if (!$assertionsDisabled && x.parent != null) {
            throw new AssertionError();
        }
        if (this.head == x) {
            this.head = x.sibling;
        } else {
            Node<K, V> y = this.head;
            while (y != null) {
                if (y.sibling == x) {
                    y.sibling = x.sibling;
                    break;
                }
                y = y.sibling;
            }
        }
        Node hprime = this._reverse(null, x.child);
        this.union(hprime);
    }

    private Node<K, V> _reverse(Node<K, V> prev, Node<K, V> n) {
        if (n == null) {
            return prev;
        }
        Node<K, V> r = this._reverse(n, n.sibling);
        n.parent = null;
        n.sibling = prev;
        return r;
    }

    @Override
    public void decreaseKey(Map.Entry<K, V> me, K newkey) {
        Node x = ((Entry)me).node;
        if (this.keyComparator().compare(newkey, x.entry.getKey()) > 0) {
            throw new UnsupportedOperationException("New key is greater than current key.");
        }
        this.setKey(x.entry, newkey);
        this._bubbleUp(x, false);
    }

    private Node<K, V> _bubbleUp(Node<K, V> x, boolean delete) {
        Node<K, V> y = x;
        Node z = y.parent;
        while (z != null && (delete || this.c.compare(y.entry, z.entry) < 0)) {
            this._exchange(y, z);
            y = z;
            z = y.parent;
        }
        return y;
    }

    private void _exchange(Node<K, V> a, Node<K, V> b) {
        Entry eb;
        Entry ea = a.entry;
        a.entry = eb = b.entry;
        eb.node = a;
        b.entry = ea;
        ea.node = b;
    }

    @Override
    public void delete(Map.Entry<K, V> me) {
        Node x = ((Entry)me).node;
        Node y = this._bubbleUp(x, true);
        this._removeRoot(y);
    }

    Node<K, V> successor(Node<K, V> n) {
        if (n == null) {
            return null;
        }
        if (n.child != null) {
            return n.child;
        }
        if (n.parent == null) {
            return n.sibling;
        }
        return n.parent.sibling;
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        return new AbstractCollection<Map.Entry<K, V>>(){

            @Override
            public int size() {
                return BinomialHeap.this.size();
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new UnmodifiableIterator<Map.Entry<K, V>>(this){
                    Node<K, V> next;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                        this.next = 1.access$000(this.this$1).head;
                    }

                    public boolean hasNext() {
                        return this.next != null;
                    }

                    public Map.Entry<K, V> next() {
                        Node<K, V> n = this.next;
                        this.next = 1.access$000(this.this$1).successor(this.next);
                        return n.entry;
                    }

                    public /* synthetic */ Object next() {
                        return this.next();
                    }
                };
            }

            @Override
            public /* synthetic */ boolean add(Object x0) {
                return super.add((Map.Entry)x0);
            }

            static /* synthetic */ BinomialHeap access$000(1 x0) {
                return x0.BinomialHeap.this;
            }
        };
    }

    @Override
    public int size() {
        int s = 0;
        Node<K, V> nx = this.head;
        while (nx != null) {
            s += 1 << nx.degree;
            nx = nx.sibling;
        }
        return s;
    }

    @Override
    public void clear() {
        this.head = null;
    }

    @Override
    public boolean isEmpty() {
        return this.head == null;
    }

    public BinomialHeap<K, V> clone() {
        BinomialHeap bm = new BinomialHeap(this.comparator());
        bm.head = this._clone(null, this.head);
        return bm;
    }

    private Node<K, V> _clone(Node<K, V> parent, Node<K, V> n) {
        if (n == null) {
            return null;
        }
        Node nn = new Node(new Entry(n.entry.getKey(), n.entry.getValue()));
        nn.degree = n.degree;
        nn.parent = parent;
        nn.child = this._clone(nn, n.child);
        nn.sibling = this._clone(parent, n.sibling);
        return nn;
    }

    public Map.Entry<K, V> find(K key) {
        Node<K, V> x = this.find(this.head, key);
        return x.entry;
    }

    private Node<K, V> find(Node<K, V> n, K key) {
        if (n == null) {
            return null;
        }
        int cmp = this.keyComparator().compare(n.entry.getKey(), key);
        if (cmp == 0) {
            return n;
        }
        Node s = this.find(n.sibling, key);
        if (s != null) {
            return s;
        }
        if (cmp > 0) {
            return null;
        }
        return this.find(n.child, key);
    }

    @Override
    protected final K setKey(Map.Entry<K, V> me, K newkey) {
        Entry e = (Entry)me;
        return e._setKey(newkey);
    }

    private void checkHeap() {
        BinomialHeap.checkHeap(this.head, this.c);
    }

    private static <K, V> void checkHeap(Node<K, V> n, Comparator<Map.Entry<K, V>> c) {
        if (!$assertionsDisabled && !BinomialHeap.isHeapOrdered(n, c)) {
            throw new AssertionError();
        }
    }

    private static <K, V> boolean isTreeOrdered(Node<K, V> n, Comparator<Map.Entry<K, V>> c) {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        if (n.parent == null) {
            return (n.sibling == null || n.sibling.parent == null) && (n.child == null || BinomialHeap.isTreeOrdered(n.child, c) && n.degree == n.child.degree + 1 && n == n.child.parent) && n.child == null == (n.degree == 0);
        }
        if (c.compare(n.entry, n.parent.entry) < 0) {
            return false;
        }
        if (n.sibling != null) {
            if (!BinomialHeap.isTreeOrdered(n.sibling, c)) {
                return false;
            }
            if (n.degree != n.sibling.degree + 1) {
                return false;
            }
            if (n.parent != n.sibling.parent) {
                return false;
            }
        }
        if (n.child != null) {
            if (!BinomialHeap.isTreeOrdered(n.child, c)) {
                return false;
            }
            if (n.degree != n.child.degree + 1) {
                return false;
            }
            if (n != n.child.parent) {
                return false;
            }
        }
        return n.degree == 0 ? n.child == null && n.sibling == null : n.child != null && n.sibling != null;
    }

    private static <K, V> boolean isHeapOrdered(Node<K, V> n, Comparator<Map.Entry<K, V>> c) {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        if (n == null) {
            return true;
        }
        return n.parent == null && BinomialHeap.isTreeOrdered(n, c) && (n.sibling == null || n.degree < n.sibling.degree && BinomialHeap.isHeapOrdered(n.sibling, c));
    }

    public static void main(String[] argv) {
        int i;
        Comparator<Integer> ic = new Comparator<Integer>(){

            @Override
            public int compare(Integer i1, Integer i2) {
                return i1 - i2;
            }

            @Override
            public /* synthetic */ int compare(Object x0, Object x1) {
                return this.compare((Integer)x0, (Integer)x1);
            }
        };
        BinomialHeap<Integer, Integer> bm1 = new BinomialHeap(ic);
        BinomialHeap bm2 = new BinomialHeap(ic);
        int[] ia = new int[]{29, 6, 14, 38, 17, 8, 11, 27, 1, 25, 12, 18, 10};
        for (i = 0; i < ia.length; ++i) {
            bm1.insert(new Integer(ia[i]), null);
        }
        System.out.println(bm1.entries());
        System.out.println(bm1.minimum());
        System.out.println("----");
        bm1.clear();
        ia = new int[]{15, 33, 28, 41, 7, 25, 12};
        for (i = 0; i < ia.length; ++i) {
            bm1.insert(new Integer(ia[i]), null);
        }
        ia = new int[]{6, 44, 10, 17, 29, 31, 48, 50, 8, 22, 23, 24, 30, 32, 45, 55, 3, 37, 18};
        for (i = 0; i < ia.length; ++i) {
            bm2.insert(new Integer(ia[i]), null);
        }
        System.out.println(bm1.entries());
        System.out.println(bm2.entries());
        bm1.union(bm2);
        System.out.println(bm1.entries());
        System.out.println(bm1.minimum());
        System.out.println("----");
        bm2 = new BinomialHeap(bm1);
        bm1.insert(new Integer(3), null);
        if (!$assertionsDisabled && bm1.size() != 27) {
            throw new AssertionError();
        }
        while (bm1.size() > 0) {
            System.out.print(new StringBuffer().append(bm1.extractMinimum().getKey().toString()).append(" ").toString());
        }
        System.out.println();
        if (!$assertionsDisabled && bm1.size() != 0) {
            throw new AssertionError();
        }
        System.out.println("----");
        bm1 = bm2.clone();
        Iterator it = bm1.entries().iterator();
        it.next();
        it.next();
        it.next();
        bm1.delete(it.next());
        if (!$assertionsDisabled && bm1.size() != 25) {
            throw new AssertionError();
        }
        while (!bm1.isEmpty()) {
            Map.Entry me = bm1.minimum();
            bm1.delete(me);
            System.out.print(new StringBuffer().append(((Integer)me.getKey()).toString()).append(" ").toString());
        }
        System.out.println();
        bm1 = new BinomialHeap<Integer, Integer>(new AbstractCollection<Map.Entry<Integer, Integer>>(){
            int[] el = new int[]{-4, -1, -3, -2, -16, -9, -10, -14, -8, -7};

            @Override
            public int size() {
                return this.el.length;
            }

            @Override
            public Iterator<Map.Entry<Integer, Integer>> iterator() {
                return new UnmodifiableIterator<Map.Entry<Integer, Integer>>(this){
                    int i;
                    private final /* synthetic */ 4 this$0;
                    {
                        this.this$0 = var1_1;
                        this.i = 0;
                    }

                    public boolean hasNext() {
                        return this.i < this.this$0.el.length;
                    }

                    public Map.Entry<Integer, Integer> next() {
                        Integer io = new Integer(this.this$0.el[this.i++]);
                        return new PairMapEntry<Integer, Integer>(io, io);
                    }

                    public /* synthetic */ Object next() {
                        return this.next();
                    }
                };
            }

            @Override
            public /* synthetic */ boolean add(Object x0) {
                return super.add((Map.Entry)x0);
            }
        }, ic);
        if (!$assertionsDisabled && (bm1.size() != 10 || bm1.isEmpty())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !bm1.minimum().getKey().equals(new Integer(-16))) {
            throw new AssertionError();
        }
        System.out.println(bm1);
        bm1.insert(new Integer(-15), new Integer(-15));
        if (!$assertionsDisabled && (bm1.size() != 11 || bm1.isEmpty())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !bm1.minimum().getKey().equals(new Integer(-16))) {
            throw new AssertionError();
        }
        System.out.println(bm1);
        if (!$assertionsDisabled && !bm1.extractMinimum().getKey().equals(new Integer(-16))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !bm1.extractMinimum().getKey().equals(new Integer(-15))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !bm1.extractMinimum().getKey().equals(new Integer(-14))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !bm1.extractMinimum().getKey().equals(new Integer(-10))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !bm1.extractMinimum().getKey().equals(new Integer(-9))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !bm1.extractMinimum().getKey().equals(new Integer(-8))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !bm1.extractMinimum().getKey().equals(new Integer(-7))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !bm1.extractMinimum().getKey().equals(new Integer(-4))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !bm1.extractMinimum().getKey().equals(new Integer(-3))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !bm1.extractMinimum().getKey().equals(new Integer(-2))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !bm1.extractMinimum().getKey().equals(new Integer(-1))) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || bm1.isEmpty() && bm1.size() == 0)) {
            throw new AssertionError();
        }
        BinomialHeap<String, String> h = new BinomialHeap<String, String>();
        if (!($assertionsDisabled || h.isEmpty() && h.size() == 0)) {
            throw new AssertionError();
        }
        ArrayList<Map.Entry<String, String>> mel = new ArrayList<Map.Entry<String, String>>();
        mel.add(h.insert("C", "c1"));
        mel.add(h.insert("S", "s1"));
        mel.add(h.insert("A", "a"));
        mel.add(h.insert("S", "s2"));
        mel.add(h.insert("C", "c2"));
        mel.add(h.insert("O", "o"));
        mel.add(h.insert("T", "t1"));
        mel.add(h.insert("T", "t2"));
        mel.add(h.insert("Z", "z"));
        mel.add(h.insert("M", "m"));
        if (!$assertionsDisabled && !((String)h.extractMinimum().getValue()).equals("a")) {
            throw new AssertionError();
        }
        System.out.println(h);
        h.decreaseKey((Map.Entry)mel.get(3), "B");
        if (!$assertionsDisabled && !((String)h.extractMinimum().getValue()).equals("s2")) {
            throw new AssertionError();
        }
        h.delete((Map.Entry)mel.get(4));
        if (!$assertionsDisabled && !((String)h.extractMinimum().getValue()).equals("c1")) {
            throw new AssertionError();
        }
        System.out.println(h);
        h.updateKey((Map.Entry)mel.get(9), "P");
        if (!$assertionsDisabled && !((String)h.extractMinimum().getValue()).equals("o")) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !((String)h.extractMinimum().getValue()).equals("m")) {
            throw new AssertionError();
        }
        System.out.println(h);
        System.out.println("PASSED.");
    }

    public /* synthetic */ Object clone() throws CloneNotSupportedException {
        return this.clone();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$net$cscott$jutil$BinomialHeap == null ? (class$net$cscott$jutil$BinomialHeap = BinomialHeap.class$("net.cscott.jutil.BinomialHeap")) : class$net$cscott$jutil$BinomialHeap).desiredAssertionStatus();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Node<K, V> {
        Node<K, V> parent;
        Entry<K, V> entry;
        int degree;
        Node<K, V> child;
        Node<K, V> sibling;

        Node(Entry<K, V> e) {
            this.entry = e;
            this.entry.node = this;
            this.degree = 0;
        }

        public String toString() {
            return new StringBuffer().append("<").append(this.entry.toString()).append(", ").append("degree: ").append(this.degree).append(", ").append("parent key: ").append(this.parent != null ? this.parent.entry.getKey().toString() : "(nil)").append(", ").append("child key: ").append(this.child != null ? this.child.entry.getKey().toString() : "(nil)").append(", ").append("sibling key: ").append(this.sibling != null ? this.sibling.entry.getKey().toString() : "(nil)").append(">").toString();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Entry<K, V>
    extends PairMapEntry<K, V> {
        Node<K, V> node;

        Entry(K key, V value) {
            super(key, value);
        }

        K _setKey(K key) {
            return super.setKey(key);
        }
    }
}

