/*
 * Decompiled with CFR 0.152.
 */
package net.cscott.jutil;

import java.util.Comparator;
import net.cscott.jutil.Default;

public class BinaryTree {
    private Node root;
    protected final Node NIL;
    protected Comparator comp;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected Node makeNode(Object key) {
        return new Node(key);
    }

    protected Node setLeft(Node p, Node l) {
        Node n = p.left;
        p.left = l;
        return n;
    }

    protected Node setRight(Node p, Node r) {
        Node n = p.right;
        p.right = r;
        return n;
    }

    protected Node setParent(Node c, Node p) {
        Node n = c.parent;
        c.parent = p;
        return n;
    }

    protected void swapPositions(Node a, Node b) {
        Node tl = a.left;
        Node tr = a.right;
        Node tp = a.parent;
        this.setLeft(a, b.left);
        this.setRight(a, b.right);
        this.setParent(a, b.parent);
        this.setLeft(b, tl);
        this.setRight(b, tr);
        this.setParent(b, tp);
        if (a.left != this.NIL && a.left.parent == b) {
            a.left.parent = a;
        }
        if (a.right != this.NIL && a.right.parent == b) {
            a.right.parent = a;
        }
        if (a.parent != this.NIL) {
            if (a.parent.left == b) {
                a.parent.left = a;
            } else if (a.parent.right == b) {
                a.parent.right = a;
            }
        }
        if (b.left != this.NIL && b.left.parent == a) {
            b.left.parent = b;
        }
        if (b.right != this.NIL && b.right.parent == a) {
            b.right.parent = b;
        }
        if (b.parent != this.NIL) {
            if (b.parent.left == a) {
                b.parent.left = b;
            } else if (b.parent.right == a) {
                b.parent.right = b;
            }
        }
        if (a == this.root) {
            this.root = b;
        } else if (b == this.root) {
            this.root = a;
        }
    }

    protected Node root() {
        return this.root;
    }

    protected Node setRoot(Node r) {
        Node n = this.root;
        this.root = r;
        return n;
    }

    private boolean lessThan(Object a, Object b) {
        return this.comp.compare(a, b) < 0;
    }

    private boolean eq(Object a, Object b) {
        return this.comp.compare(a, b) == 0;
    }

    public BinaryTree() {
        this(Default.comparator);
    }

    public BinaryTree(Comparator c) {
        this.root = this.NIL = this.makeNode(null);
        this.comp = c;
    }

    public Node add(Object k) {
        Node n = this.makeNode(k);
        this.insertNode(n);
        return n;
    }

    public void remove(Object k) {
        Node n = this.search(this.root, k);
        if (n != this.NIL) {
            this.deleteNode(n);
        }
    }

    public boolean contains(Object k) {
        return this.search(this.root, k) != this.NIL;
    }

    public Object minimum() {
        return this.minimum((Node)this.root).key;
    }

    public Object maximum() {
        return this.maximum((Node)this.root).key;
    }

    protected Node search(Node x, Object k) {
        while (x != this.NIL && !this.eq(k, x.key)) {
            if (this.lessThan(k, x.key)) {
                x = x.left;
                continue;
            }
            x = x.right;
        }
        return x;
    }

    protected Node minimum(Node x) {
        while (x.left != this.NIL) {
            x = x.left;
        }
        return x;
    }

    protected Node maximum(Node x) {
        while (x.right != this.NIL) {
            x = x.right;
        }
        return x;
    }

    protected Node successor(Node x) {
        if (x.right != this.NIL) {
            return this.minimum(x.right);
        }
        Node y = x.parent;
        while (y != this.NIL && this.eq(x, y.right)) {
            x = y;
            y = y.parent;
        }
        return y;
    }

    protected void insertNode(Node z) {
        if (!$assertionsDisabled && z == this.NIL) {
            throw new AssertionError();
        }
        Node y = this.NIL;
        Node x = this.root;
        while (x != this.NIL) {
            y = x;
            if (this.lessThan(z.key, x.key)) {
                x = x.left;
                continue;
            }
            x = x.right;
        }
        z.parent = y;
        if (y == this.NIL) {
            this.root = z;
        } else if (this.lessThan(z.key, y.key)) {
            y.left = z;
        } else {
            y.right = z;
        }
    }

    protected void deleteNode(Node z) {
        Node y = z.left == this.NIL || z.right == this.NIL ? z : this.successor(z);
        Node x = y.left != this.NIL ? y.left : y.right;
        if (x != this.NIL) {
            x.parent = y.parent;
        }
        if (y.parent == this.NIL) {
            this.root = x;
        } else if (y == y.parent.left) {
            y.parent.left = x;
        } else {
            y.parent.right = x;
        }
        if (y != this.NIL && y != z) {
            this.swapPositions(y, z);
        }
    }

    private void inorderTreeWalk() {
        this.inorderTreeWalk(this.root);
    }

    private void inorderTreeWalk(Node x) {
        if (x != this.NIL) {
            this.inorderTreeWalk(x.left);
            System.out.print(x.key);
            System.out.print(' ');
            this.inorderTreeWalk(x.right);
        }
    }

    public void test() {
        int i;
        String[] strings = new String[]{"foo", "bar", "wistfully_3", "willing_4", "whilst_5", "whitling_6", "away_7", "at_8", "the_9", "bar"};
        for (i = 0; i < strings.length; ++i) {
            this.add(strings[i]);
            this.inorderTreeWalk();
            System.out.println();
        }
        for (i = 0; i < strings.length; ++i) {
            this.remove(strings[i]);
            this.inorderTreeWalk();
            System.out.println();
        }
    }

    public static void main(String[] args) {
        BinaryTree t = new BinaryTree();
        t.test();
    }

    public String dump() {
        return this.dump(this.root);
    }

    public String dump(Node x) {
        if (x == this.NIL) {
            return ".";
        }
        return "(" + x + " " + this.dump(x.left) + " " + this.dump(x.right) + ")";
    }

    static {
        $assertionsDisabled = !BinaryTree.class.desiredAssertionStatus();
    }

    public class Node {
        public final Object key;
        private Node left;
        private Node right;
        private Node parent;

        protected final Node left() {
            return this.left;
        }

        protected final Node right() {
            return this.right;
        }

        protected final Node parent() {
            return this.parent;
        }

        protected Node(Object k) {
            this.key = k;
            this.right = this.parent = BinaryTree.this.NIL;
            this.left = this.parent;
        }

        public String toString() {
            return "node: " + this.key;
        }
    }
}

