/*
 * Decompiled with CFR 0.152.
 */
package net.cscott.jutil;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import net.cscott.jutil.AbstractHeap;
import net.cscott.jutil.Heap;
import net.cscott.jutil.PairMapEntry;
import net.cscott.jutil.UnmodifiableIterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BinaryHeap<K, V>
extends AbstractHeap<K, V> {
    private final boolean debug = false;
    final ArrayList<Entry<K, V>> A;
    final Comparator<Map.Entry<K, V>> c = this.entryComparator();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$net$cscott$jutil$BinaryHeap;

    public BinaryHeap() {
        this(Collections.EMPTY_SET, null);
    }

    public BinaryHeap(Comparator<K> c) {
        this(Collections.EMPTY_SET, c);
    }

    public BinaryHeap(Heap<K, ? extends V> h) {
        this(h.entries(), h.comparator());
    }

    public BinaryHeap(Collection<? extends Map.Entry<? extends K, ? extends V>> collection, Comparator<K> comparator) {
        super(comparator);
        this.A = new ArrayList(1 + collection.size());
        this.A.add(null);
        this.union(collection);
    }

    @Override
    public Map.Entry<K, V> insert(K key, V value) {
        int index = this.A.size();
        Entry<K, V> e = new Entry<K, V>(key, value, index);
        this.A.add(e);
        this.upheap(index);
        return e;
    }

    @Override
    public Map.Entry<K, V> minimum() {
        if (this.size() < 1) {
            throw new NoSuchElementException();
        }
        return this.A.get(1);
    }

    @Override
    public Map.Entry<K, V> extractMinimum() {
        if (this.size() < 1) {
            throw new NoSuchElementException();
        }
        Entry<K, V> min = this.A.get(1);
        this.set(1, this.A.get(this.size()));
        this.A.remove(this.size());
        this.downheap(1);
        return min;
    }

    @Override
    public void union(Heap<? extends K, ? extends V> h) {
        this.union(h.entries());
    }

    private void union(Collection<? extends Map.Entry<? extends K, ? extends V>> coll) {
        for (Map.Entry<K, V> e : coll) {
            this.A.add(new Entry<K, V>(e.getKey(), e.getValue(), this.A.size()));
        }
        for (int i = this.size() / 2; i > 0; --i) {
            this.downheap(i);
        }
    }

    @Override
    public void decreaseKey(Map.Entry<K, V> me, K newkey) {
        this.updateKey(me, newkey);
    }

    @Override
    public void updateKey(Map.Entry<K, V> me, K newkey) {
        Entry e = (Entry)me;
        if (this.keyComparator().compare(newkey, this.setKey(e, newkey)) < 0) {
            this.upheap(e.index);
        } else {
            this.downheap(e.index);
        }
    }

    @Override
    public void delete(Map.Entry<K, V> me) {
        int index = ((Entry)me).index;
        Entry<K, V> newE = this.A.get(this.size());
        this.set(index, newE);
        this.A.remove(this.size());
        if (this.c.compare(newE, me) < 0) {
            this.upheap(index);
        } else {
            this.downheap(index);
        }
    }

    @Override
    public void clear() {
        this.A.clear();
        this.A.add(null);
    }

    @Override
    public int size() {
        return this.A.size() - 1;
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        return new AbstractCollection<Map.Entry<K, V>>(){

            @Override
            public int size() {
                return BinaryHeap.this.size();
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                Iterator it = BinaryHeap.this.A.iterator();
                it.next();
                return new UnmodifiableIterator<Map.Entry<K, V>>(){
                    private final /* synthetic */ Iterator val$it;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$it = iterator;
                    }

                    public boolean hasNext() {
                        return this.val$it.hasNext();
                    }

                    public Map.Entry<K, V> next() {
                        return (Map.Entry)this.val$it.next();
                    }

                    public /* synthetic */ Object next() {
                        return this.next();
                    }
                };
            }

            @Override
            public /* synthetic */ boolean add(Object x0) {
                return super.add((Map.Entry)x0);
            }
        };
    }

    private final void downheap(int i) {
        int l = BinaryHeap.LEFT(i);
        int r = BinaryHeap.RIGHT(i);
        int smallest = i;
        if (l <= this.size() && this.c.compare(this.A.get(l), this.A.get(smallest)) < 0) {
            smallest = l;
        }
        if (r <= this.size() && this.c.compare(this.A.get(r), this.A.get(smallest)) < 0) {
            smallest = r;
        }
        if (smallest != i) {
            this.exchange(i, smallest);
            this.downheap(smallest);
        }
    }

    private final void upheap(int i) {
        int p = BinaryHeap.PARENT(i);
        if (p > 0 && i <= this.size() && this.c.compare(this.A.get(p), this.A.get(i)) > 0) {
            this.exchange(p, i);
            this.upheap(p);
        }
    }

    private final void exchange(int i, int j) {
        if (i == j) {
            return;
        }
        Entry<K, V> ei = this.A.get(i);
        Entry<K, V> ej = this.A.get(j);
        this.A.set(i, ej);
        ej.index = i;
        this.A.set(j, ei);
        ei.index = j;
    }

    private final void set(int i, Entry<K, V> e) {
        this.A.set(i, e);
        e.index = i;
    }

    private static final int LEFT(int i) {
        return 2 * i;
    }

    private static final int RIGHT(int i) {
        return 2 * i + 1;
    }

    private static final int PARENT(int i) {
        return i / 2;
    }

    private final void checkHeap() {
        for (int i = 2; i < this.A.size(); ++i) {
            if (!$assertionsDisabled && this.c.compare(this.A.get(BinaryHeap.PARENT(i)), this.A.get(i)) > 0) {
                throw new AssertionError();
            }
        }
    }

    @Override
    protected final K setKey(Map.Entry<K, V> me, K newkey) {
        Entry e = (Entry)me;
        return e._setKey(newkey);
    }

    public static void main(String[] args) {
        BinaryHeap<Object, Object> h = new BinaryHeap();
        if (!($assertionsDisabled || h.size() == 0 && h.isEmpty())) {
            throw new AssertionError();
        }
        h = new BinaryHeap<Integer, Integer>(new AbstractCollection<Map.Entry<Integer, Integer>>(){
            int[] el = new int[]{-4, -1, -3, -2, -16, -9, -10, -14, -8, -7};

            @Override
            public int size() {
                return this.el.length;
            }

            @Override
            public Iterator<Map.Entry<Integer, Integer>> iterator() {
                return new UnmodifiableIterator<Map.Entry<Integer, Integer>>(this){
                    int i;
                    private final /* synthetic */ 3 this$0;
                    {
                        this.this$0 = var1_1;
                        this.i = 0;
                    }

                    public boolean hasNext() {
                        return this.i < this.this$0.el.length;
                    }

                    public Map.Entry<Integer, Integer> next() {
                        Integer io = new Integer(this.this$0.el[this.i++]);
                        return new PairMapEntry<Integer, Integer>(io, io);
                    }

                    public /* synthetic */ Object next() {
                        return this.next();
                    }
                };
            }

            @Override
            public /* synthetic */ boolean add(Object x0) {
                return super.add((Map.Entry)x0);
            }
        }, null);
        if (!$assertionsDisabled && (h.size() != 10 || h.isEmpty())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !((Integer)h.minimum().getKey()).equals(new Integer(-16))) {
            throw new AssertionError();
        }
        System.out.println(h);
        h.insert(new Integer(-15), new Integer(-15));
        if (!$assertionsDisabled && (h.size() != 11 || h.isEmpty())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !((Integer)h.minimum().getKey()).equals(new Integer(-16))) {
            throw new AssertionError();
        }
        System.out.println(h);
        if (!$assertionsDisabled && !((Integer)h.extractMinimum().getKey()).equals(new Integer(-16))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !((Integer)h.extractMinimum().getKey()).equals(new Integer(-15))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !((Integer)h.extractMinimum().getKey()).equals(new Integer(-14))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !((Integer)h.extractMinimum().getKey()).equals(new Integer(-10))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !((Integer)h.extractMinimum().getKey()).equals(new Integer(-9))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !((Integer)h.extractMinimum().getKey()).equals(new Integer(-8))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !((Integer)h.extractMinimum().getKey()).equals(new Integer(-7))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !((Integer)h.extractMinimum().getKey()).equals(new Integer(-4))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !((Integer)h.extractMinimum().getKey()).equals(new Integer(-3))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !((Integer)h.extractMinimum().getKey()).equals(new Integer(-2))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !((Integer)h.extractMinimum().getKey()).equals(new Integer(-1))) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || h.isEmpty() && h.size() == 0)) {
            throw new AssertionError();
        }
        h.clear();
        if (!($assertionsDisabled || h.isEmpty() && h.size() == 0)) {
            throw new AssertionError();
        }
        h = new BinaryHeap();
        if (!($assertionsDisabled || h.size() == 0 && h.isEmpty())) {
            throw new AssertionError();
        }
        ArrayList<Map.Entry<Object, Object>> mel = new ArrayList<Map.Entry<Object, Object>>();
        mel.add(h.insert("C", "c1"));
        mel.add(h.insert("S", "s1"));
        mel.add(h.insert("A", "a"));
        mel.add(h.insert("S", "s2"));
        mel.add(h.insert("C", "c2"));
        mel.add(h.insert("O", "o"));
        mel.add(h.insert("T", "t1"));
        mel.add(h.insert("T", "t2"));
        mel.add(h.insert("Z", "z"));
        mel.add(h.insert("M", "m"));
        if (!$assertionsDisabled && !((String)h.extractMinimum().getValue()).equals("a")) {
            throw new AssertionError();
        }
        System.out.println(h);
        h.decreaseKey((Map.Entry)mel.get(3), "B");
        if (!$assertionsDisabled && !((String)h.extractMinimum().getValue()).equals("s2")) {
            throw new AssertionError();
        }
        h.delete((Map.Entry)mel.get(4));
        if (!$assertionsDisabled && !((String)h.extractMinimum().getValue()).equals("c1")) {
            throw new AssertionError();
        }
        System.out.println(h);
        h.updateKey((Map.Entry)mel.get(9), "P");
        if (!$assertionsDisabled && !((String)h.extractMinimum().getValue()).equals("o")) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !((String)h.extractMinimum().getValue()).equals("m")) {
            throw new AssertionError();
        }
        System.out.println(h);
        System.out.println("PASSED.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$net$cscott$jutil$BinaryHeap == null ? (class$net$cscott$jutil$BinaryHeap = BinaryHeap.class$("net.cscott.jutil.BinaryHeap")) : class$net$cscott$jutil$BinaryHeap).desiredAssertionStatus();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<K, V>
    extends PairMapEntry<K, V> {
        int index;

        Entry(K key, V value, int index) {
            super(key, value);
            this.index = index;
        }

        K _setKey(K newKey) {
            return this.setKey(newKey);
        }
    }
}

