/*
 * Decompiled with CFR 0.152.
 */
package net.cscott.jutil;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.cscott.jutil.SetFactory;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateSetFactory<V>
extends SetFactory<V>
implements Serializable {
    private final Map<EntryList<V>, EntryList<V>> m = new HashMap<EntryList<V>, EntryList<V>>();
    static /* synthetic */ Class class$net$cscott$jutil$AggregateSetFactory;

    @Override
    public Set<V> makeSet(Collection<? extends V> c) {
        return new AggregateSet(c);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ID<E>
    extends Header<E> {
        private ID() {
        }

        @Override
        ID<E> identity() {
            return this;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EntryList<E>
    extends Header<E> {
        final ID<E> id;
        final E value;
        Header<E> prev = null;

        EntryList(ID<E> id, E value) {
            this.id = id;
            this.value = value;
        }

        void remove() {
            this.prev.next = this.next;
            if (this.next != null) {
                this.next.prev = this.prev;
            }
            this.next = null;
            this.prev = null;
        }

        @Override
        ID<E> identity() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (!(o instanceof EntryList)) {
                return false;
            }
            EntryList e = (EntryList)o;
            return this.id == e.id && (this.value == null ? e.value == null : this.value.equals(e.value));
        }

        public int hashCode() {
            return this.id.hashCode() + (this.value == null ? 0 : this.value.hashCode());
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Header<E>
    implements Serializable {
        EntryList<E> next = null;

        Header() {
        }

        void add(EntryList<E> nel) {
            nel.next = this.next;
            nel.prev = this;
            if (nel.next != null) {
                nel.next.prev = nel;
            }
            this.next = nel;
        }

        abstract ID<E> identity();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AggregateSet
    extends AbstractSet<V> {
        final ID<V> IDENTITY = new ID();
        int size = 0;
        static final /* synthetic */ boolean $assertionsDisabled;

        AggregateSet(Collection<? extends V> c) {
            this.addAll(c);
        }

        @Override
        public boolean add(V o) {
            EntryList entry = new EntryList(this.IDENTITY, o);
            if (AggregateSetFactory.this.m.containsKey(entry)) {
                return false;
            }
            this.IDENTITY.add(entry);
            AggregateSetFactory.this.m.put(entry, entry);
            ++this.size;
            return true;
        }

        @Override
        public boolean contains(Object o) {
            return AggregateSetFactory.this.m.containsKey(new EntryList<Object>(this.IDENTITY, o));
        }

        @Override
        public boolean isEmpty() {
            if (!$assertionsDisabled && this.size == 0 != (this.IDENTITY.next == null)) {
                throw new AssertionError();
            }
            return this.size == 0;
        }

        @Override
        public Iterator<V> iterator() {
            return new Iterator<V>(this){
                Header<V> entry;
                private boolean removeValid;
                private final /* synthetic */ AggregateSet this$1;
                {
                    this.this$1 = aggregateSet;
                    this.entry = this.this$1.IDENTITY;
                    this.removeValid = false;
                }

                public boolean hasNext() {
                    return this.entry.next != null;
                }

                public V next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.removeValid = true;
                    EntryList<V> nentry = this.entry.next;
                    this.entry = nentry;
                    return (V)nentry.value;
                }

                public void remove() {
                    if (!this.removeValid) {
                        throw new IllegalStateException();
                    }
                    EntryList oentry = (EntryList)this.entry;
                    this.entry = oentry.prev;
                    AggregateSet.access$200(this.this$1, oentry);
                    this.removeValid = false;
                }
            };
        }

        private void remove(EntryList<V> entry) {
            EntryList e = (EntryList)AggregateSetFactory.this.m.remove(entry);
            if (!$assertionsDisabled && e != entry) {
                throw new AssertionError();
            }
            e.remove();
            --this.size;
        }

        @Override
        public boolean remove(Object o) {
            EntryList entry = (EntryList)AggregateSetFactory.this.m.get(new EntryList<Object>(this.IDENTITY, o));
            if (entry == null) {
                return false;
            }
            this.remove(entry);
            return true;
        }

        @Override
        public int size() {
            return this.size;
        }

        protected void finalize() {
            this.clear();
        }

        static /* synthetic */ void access$200(AggregateSet x0, EntryList x1) {
            x0.remove(x1);
        }

        static {
            $assertionsDisabled = !(class$net$cscott$jutil$AggregateSetFactory == null ? (class$net$cscott$jutil$AggregateSetFactory = AggregateSetFactory.class$("net.cscott.jutil.AggregateSetFactory")) : class$net$cscott$jutil$AggregateSetFactory).desiredAssertionStatus();
        }
    }
}

