/*
 * Decompiled with CFR 0.152.
 */
package net.cscott.jutil;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.cscott.jutil.AggregateMapFactory;
import net.cscott.jutil.Default;
import net.cscott.jutil.MapFactory;
import net.cscott.jutil.MapSet;
import net.cscott.jutil.PairMapEntry;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateMapFactory<K, V>
extends MapFactory<K, V>
implements Serializable {
    private final Map<Map.Entry<ID, K>, DoublyLinkedList<K, V>> m = new HashMap<Map.Entry<ID, K>, DoublyLinkedList<K, V>>();

    @Override
    public Map<K, V> makeMap(Map<? extends K, ? extends V> mm) {
        return new AggregateMap(mm);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractMapSet<K, V>
    extends AbstractSet<Map.Entry<K, V>>
    implements MapSet<K, V> {
        private AbstractMapSet() {
        }

        @Override
        public /* synthetic */ boolean add(Object x0) {
            return super.add((Map.Entry)x0);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DoublyLinkedList<K, V>
    extends PairMapEntry<K, V> {
        DoublyLinkedList<K, V> next;
        DoublyLinkedList<K, V> prev;

        DoublyLinkedList(K key, V value) {
            super(key, value);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AggregateMap
    extends AbstractMap<K, V> {
        final ID IDENTITY = new ID();
        DoublyLinkedList<K, V> entries = null;
        int size = 0;

        AggregateMap(Map<? extends K, ? extends V> mm) {
            this.putAll(mm);
        }

        private void unlink(DoublyLinkedList<K, V> entry) {
            if (this.entries == entry) {
                this.entries = entry.next;
            } else {
                entry.prev.next = entry.next;
                if (entry.next != null) {
                    entry.next.prev = entry.prev;
                }
            }
            --this.size;
        }

        private void link(DoublyLinkedList<K, V> entry) {
            entry.next = this.entries;
            if (this.entries != null) {
                this.entries.prev = entry;
            }
            this.entries = entry;
            ++this.size;
        }

        @Override
        public V put(K key, V value) {
            DoublyLinkedList entry = new DoublyLinkedList(key, value);
            DoublyLinkedList old = AggregateMapFactory.this.m.put(Default.entry(this.IDENTITY, key), entry);
            if (old != null) {
                this.unlink(old);
            }
            this.link(entry);
            return old == null ? null : (Object)old.getValue();
        }

        @Override
        public boolean containsKey(Object key) {
            return AggregateMapFactory.this.m.containsKey(Default.entry(this.IDENTITY, key));
        }

        @Override
        public boolean containsValue(Object value) {
            DoublyLinkedList dll = this.entries;
            while (dll != null) {
                if (value == null ? value == dll.getValue() : value.equals(dll.getValue())) {
                    return true;
                }
                dll = dll.next;
            }
            return false;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new AbstractMapSet<K, V>(this){
                private final /* synthetic */ AggregateMap this$1;
                {
                    this.this$1 = aggregateMap;
                }

                public Iterator<Map.Entry<K, V>> iterator() {
                    return new Iterator<Map.Entry<K, V>>(this){
                        DoublyLinkedList<K, V> dll;
                        DoublyLinkedList<K, V> last;
                        private final /* synthetic */ 1 this$2;
                        {
                            this.this$2 = var1_1;
                            this.dll = 1.access$300(this.this$2).entries;
                            this.last = null;
                        }

                        public boolean hasNext() {
                            return this.dll != null;
                        }

                        public Map.Entry<K, V> next() {
                            if (this.dll == null) {
                                throw new NoSuchElementException();
                            }
                            this.last = this.dll;
                            this.dll = this.dll.next;
                            return this.last;
                        }

                        public void remove() {
                            if (this.last == null) {
                                throw new UnsupportedOperationException();
                            }
                            AggregateMapFactory.access$100(AggregateMap.access$400(1.access$300(this.this$2))).remove(Default.entry(1.access$300(this.this$2).IDENTITY, this.last.getKey()));
                            AggregateMap.access$500(1.access$300(this.this$2), this.last);
                            this.last = null;
                        }

                        public /* synthetic */ Object next() {
                            return this.next();
                        }
                    };
                }

                public int size() {
                    return this.this$1.size;
                }

                public boolean add(Map.Entry<K, V> me) {
                    if (me == null) {
                        throw new UnsupportedOperationException();
                    }
                    if (this.contains(me)) {
                        return false;
                    }
                    if (this.this$1.containsKey(me.getKey())) {
                        throw new UnsupportedOperationException();
                    }
                    this.this$1.put(me.getKey(), me.getValue());
                    return true;
                }

                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry me = (Map.Entry)o;
                    Map.Entry<ID, K> pair = Default.entry(this.this$1.IDENTITY, me.getKey());
                    if (!AggregateMapFactory.access$100(AggregateMap.access$400(this.this$1)).containsKey(pair)) {
                        return false;
                    }
                    return ((Object)me).equals(AggregateMapFactory.access$100(AggregateMap.access$400(this.this$1)).get(pair));
                }

                public boolean remove(Object o) {
                    if (!this.contains(o)) {
                        return false;
                    }
                    Map.Entry me = (Map.Entry)o;
                    this.this$1.remove(me.getKey());
                    return true;
                }

                public Map<K, V> asMap() {
                    return this.this$1;
                }

                public /* synthetic */ boolean add(Object x0) {
                    return this.add((Map.Entry)x0);
                }

                static /* synthetic */ AggregateMap access$300(1 x0) {
                    return x0.this$1;
                }
            };
        }

        @Override
        public V get(Object key) {
            DoublyLinkedList entry = (DoublyLinkedList)AggregateMapFactory.this.m.get(Default.entry(this.IDENTITY, key));
            return entry == null ? null : (Object)entry.getValue();
        }

        @Override
        public V remove(Object key) {
            DoublyLinkedList entry = (DoublyLinkedList)AggregateMapFactory.this.m.remove(Default.entry(this.IDENTITY, key));
            if (entry != null) {
                this.unlink(entry);
            }
            return entry == null ? null : (Object)entry.getValue();
        }

        @Override
        public int size() {
            return this.size;
        }

        protected void finalize() {
            this.clear();
        }

        static /* synthetic */ AggregateMapFactory access$400(AggregateMap x0) {
            return x0.AggregateMapFactory.this;
        }

        static /* synthetic */ void access$500(AggregateMap x0, DoublyLinkedList x1) {
            x0.unlink(x1);
        }
    }

    private static final class ID {
        private ID() {
        }
    }
}

