/*
 * Decompiled with CFR 0.152.
 */
package net.cscott.jutil;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import net.cscott.jutil.Default;
import net.cscott.jutil.Heap;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHeap<K, V>
implements Heap<K, V> {
    private final Comparator<K> keyComparator;
    private final EntryComparator<K, V> entryComparator;

    protected AbstractHeap(Comparator<K> c) {
        if (c == null) {
            c = Default.comparator;
        }
        this.keyComparator = c;
        this.entryComparator = new EntryComparator(c);
    }

    @Override
    public abstract Map.Entry<K, V> insert(K var1, V var2);

    @Override
    public abstract Map.Entry<K, V> minimum();

    @Override
    public abstract void decreaseKey(Map.Entry<K, V> var1, K var2);

    @Override
    public abstract void delete(Map.Entry<K, V> var1);

    @Override
    public abstract int size();

    @Override
    public abstract Collection<Map.Entry<K, V>> entries();

    @Override
    public abstract void clear();

    @Override
    public void updateKey(Map.Entry<K, V> me, K newkey) {
        int r = this.keyComparator.compare(me.getKey(), newkey);
        if (r > 0) {
            this.decreaseKey(me, newkey);
        }
        if (r >= 0) {
            return;
        }
        this.delete(me);
        this.setKey(me, newkey);
        this.insert(me);
    }

    protected void insert(Map.Entry<K, V> me) {
        throw new UnsupportedOperationException();
    }

    protected K setKey(Map.Entry<K, V> me, K newkey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map.Entry<K, V> extractMinimum() {
        Map.Entry<K, V> e = this.minimum();
        this.delete(e);
        return e;
    }

    @Override
    public void union(Heap<? extends K, ? extends V> h) {
        for (Map.Entry<K, V> e : h.entries()) {
            this.insert(e.getKey(), e.getValue());
        }
        h.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        return 1 + ((Object)this.entries()).hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Heap) {
            return ((Object)this.entries()).equals(((Heap)o).entries());
        }
        return false;
    }

    @Override
    public String toString() {
        return this.entries().toString();
    }

    @Override
    public Comparator<K> comparator() {
        return this.entryComparator.cc;
    }

    protected Comparator<K> keyComparator() {
        return this.keyComparator;
    }

    protected Comparator<Map.Entry<K, V>> entryComparator() {
        return this.entryComparator;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EntryComparator<K, V>
    implements Comparator<Map.Entry<K, V>> {
        final Comparator<K> cc;

        EntryComparator(Comparator<K> cc) {
            this.cc = cc;
        }

        @Override
        public int compare(Map.Entry<K, V> e1, Map.Entry<K, V> e2) {
            K k1 = e1.getKey();
            K k2 = e2.getKey();
            return this.cc == null ? ((Comparable)k1).compareTo(k2) : this.cc.compare(k1, k2);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof EntryComparator) {
                EntryComparator ec = (EntryComparator)obj;
                return this.cc == null ? ec.cc == null : ((Object)this.cc).equals(ec.cc);
            }
            return false;
        }

        @Override
        public /* synthetic */ int compare(Object x0, Object x1) {
            return this.compare((Map.Entry)x0, (Map.Entry)x1);
        }
    }
}

